/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.cache.gae;

import com.google.appengine.api.memcache.AsyncMemcacheService;
import com.google.appengine.api.memcache.MemcacheService;
import com.google.appengine.api.memcache.MemcacheServiceFactory;
import com.google.appengine.api.memcache.Stats;
import java.io.Serializable;
import java.util.Collection;
import org.b3log.latke.cache.Cache;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.util.Serializer;

public final class Memcache<K extends Serializable, V extends Serializable>
implements Cache<K, V> {
    private static final Logger LOGGER = Logger.getLogger((String)Memcache.class.getName());
    private MemcacheService memcacheService;
    private AsyncMemcacheService asyncMemcacheService;
    private String name;
    private static final int TRUE_INT = 49;
    private static final int FALSE_INT = 48;

    public Memcache(String name) {
        this.name = name;
        this.memcacheService = MemcacheServiceFactory.getMemcacheService((String)name);
        this.asyncMemcacheService = MemcacheServiceFactory.getAsyncMemcacheService((String)name);
    }

    public String getName() {
        return this.name;
    }

    public boolean contains(K key) {
        return this.memcacheService.contains(key);
    }

    public void put(K key, V value) {
        if (null == key) {
            throw new IllegalArgumentException("The specified key can not be null!");
        }
        if (null == value) {
            throw new IllegalArgumentException("The specified value can not be null![key=" + key + "]");
        }
        try {
            this.memcacheService.put(key, value);
        }
        catch (Exception e) {
            try {
                LOGGER.log(Level.WARN, "Can not put memcache[key=" + key + ", valueSize=" + Serializer.serialize(value).length, (Throwable)e);
            }
            catch (Exception ex) {
                LOGGER.log(Level.ERROR, " Serializes failed", (Throwable)ex);
            }
        }
    }

    public void putAsync(K key, V value) {
        if (null == key) {
            throw new IllegalArgumentException("The specified key can not be null!");
        }
        if (null == value) {
            throw new IllegalArgumentException("The specified value can not be null![key=" + key + "]");
        }
        try {
            this.asyncMemcacheService.put(key, value);
        }
        catch (Exception e) {
            try {
                LOGGER.log(Level.WARN, "Can not put async memcache[key=" + key + ", valueSize=" + Serializer.serialize(value).length, (Throwable)e);
            }
            catch (Exception ex) {
                LOGGER.log(Level.ERROR, " Serializes failed", (Throwable)ex);
            }
        }
    }

    public V get(K key) {
        if (null == key) {
            return null;
        }
        return (V)((Serializable)this.memcacheService.get(key));
    }

    public long inc(K key, long delta) {
        if (null == key) {
            throw new IllegalArgumentException("The specified key can not be null!");
        }
        if (!this.memcacheService.contains(key)) {
            this.memcacheService.put(key, (Object)1L);
        }
        return this.memcacheService.increment(key, delta);
    }

    public void remove(K key) {
        this.memcacheService.delete(key);
    }

    public void remove(Collection<K> keys) {
        this.memcacheService.deleteAll(keys);
    }

    public void removeAll() {
        this.memcacheService.clearAll();
        LOGGER.trace("Clear all caches");
    }

    public void setMaxCount(long maxCount) {
    }

    public long getMaxCount() {
        return Long.MAX_VALUE;
    }

    public long getHitCount() {
        Stats statistics = this.memcacheService.getStatistics();
        if (null != statistics) {
            return statistics.getHitCount();
        }
        return -1L;
    }

    public long getMissCount() {
        Stats statistics = this.memcacheService.getStatistics();
        if (null != statistics) {
            return statistics.getMissCount();
        }
        return -1L;
    }

    public long getPutCount() {
        return this.getCachedCount();
    }

    public long getCachedBytes() {
        Stats statistics = this.memcacheService.getStatistics();
        if (null != statistics) {
            return statistics.getTotalItemBytes();
        }
        return -1L;
    }

    public long getHitBytes() {
        Stats statistics = this.memcacheService.getStatistics();
        if (null != statistics) {
            return statistics.getBytesReturnedForHits();
        }
        return -1L;
    }

    public long getCachedCount() {
        Stats statistics = this.memcacheService.getStatistics();
        if (null != statistics) {
            return statistics.getItemCount();
        }
        return -1L;
    }

    public void collect() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

