/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.repository.gae;

import java.util.ConcurrentModificationException;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.repository.Transaction;
import org.b3log.latke.repository.gae.GAERepository;

public final class GAETransaction
implements Transaction {
    private static final Logger LOGGER = Logger.getLogger((String)GAETransaction.class.getName());
    private com.google.appengine.api.datastore.Transaction appEngineDatastoreTx;
    public static final int COMMIT_RETRIES = 3;

    public GAETransaction(com.google.appengine.api.datastore.Transaction appEngineDatastoreTx) {
        this.appEngineDatastoreTx = appEngineDatastoreTx;
    }

    public String getId() {
        return this.appEngineDatastoreTx.getId();
    }

    public void commit() {
        int retries = 3;
        while (true) {
            try {
                this.appEngineDatastoreTx.commit();
                GAERepository.TX.set(null);
            }
            catch (ConcurrentModificationException e) {
                if (retries == 0) {
                    throw e;
                }
                --retries;
                LOGGER.log(Level.WARN, "Retrying to commit this transaction[id={0}, app={1}]", new Object[]{this.appEngineDatastoreTx.getId(), this.appEngineDatastoreTx.getApp()});
                continue;
            }
            break;
        }
    }

    public void rollback() {
        this.appEngineDatastoreTx.rollback();
        GAERepository.TX.set(null);
    }

    public boolean isActive() {
        return this.appEngineDatastoreTx.isActive();
    }
}

