/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.urlfetch.gae;

import com.google.appengine.api.urlfetch.HTTPMethod;
import com.google.appengine.api.urlfetch.URLFetchServiceFactory;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.Future;
import org.b3log.latke.servlet.HTTPRequestMethod;
import org.b3log.latke.urlfetch.HTTPHeader;
import org.b3log.latke.urlfetch.HTTPRequest;
import org.b3log.latke.urlfetch.HTTPResponse;
import org.b3log.latke.urlfetch.URLFetchService;

public final class GAEURLFetchService
implements URLFetchService {
    private static final com.google.appengine.api.urlfetch.URLFetchService URL_FETCH_SERVICE = URLFetchServiceFactory.getURLFetchService();
    private static final double DEFAULT_TIMEOUT = 5.0;

    public HTTPResponse fetch(HTTPRequest request) throws IOException {
        com.google.appengine.api.urlfetch.HTTPRequest gaeHTTPRequest = GAEURLFetchService.toGAEHTTPRequest(request);
        com.google.appengine.api.urlfetch.HTTPResponse gaeHTTPResponse = URL_FETCH_SERVICE.fetch(gaeHTTPRequest);
        return GAEURLFetchService.toHTTPResponse(gaeHTTPResponse);
    }

    public Future<?> fetchAsync(HTTPRequest request) {
        com.google.appengine.api.urlfetch.HTTPRequest gaeHTTPRequest = GAEURLFetchService.toGAEHTTPRequest(request);
        return URL_FETCH_SERVICE.fetchAsync(gaeHTTPRequest);
    }

    private static HTTPResponse toHTTPResponse(com.google.appengine.api.urlfetch.HTTPResponse response) {
        HTTPResponse ret = new HTTPResponse();
        ret.setContent(response.getContent());
        ret.setFinalURL(response.getFinalUrl());
        ret.setResponseCode(response.getResponseCode());
        List gaeHTTPHeaders = response.getHeaders();
        for (com.google.appengine.api.urlfetch.HTTPHeader gaeHTTPHeader : gaeHTTPHeaders) {
            HTTPHeader header = new HTTPHeader(gaeHTTPHeader.getName(), gaeHTTPHeader.getValue());
            ret.addHeader(header);
        }
        return ret;
    }

    private static com.google.appengine.api.urlfetch.HTTPRequest toGAEHTTPRequest(HTTPRequest request) {
        URL url = request.getURL();
        HTTPRequestMethod requestMethod = request.getRequestMethod();
        com.google.appengine.api.urlfetch.HTTPRequest ret = null;
        switch (requestMethod) {
            case GET: {
                ret = new com.google.appengine.api.urlfetch.HTTPRequest(url);
                break;
            }
            case DELETE: {
                ret = new com.google.appengine.api.urlfetch.HTTPRequest(url, HTTPMethod.DELETE);
                break;
            }
            case HEAD: {
                ret = new com.google.appengine.api.urlfetch.HTTPRequest(url, HTTPMethod.HEAD);
                break;
            }
            case POST: {
                ret = new com.google.appengine.api.urlfetch.HTTPRequest(url, HTTPMethod.POST);
                break;
            }
            case PUT: {
                ret = new com.google.appengine.api.urlfetch.HTTPRequest(url, HTTPMethod.PUT);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported HTTP request method[" + requestMethod.name() + "]");
            }
        }
        List headers = request.getHeaders();
        for (HTTPHeader header : headers) {
            ret.addHeader(new com.google.appengine.api.urlfetch.HTTPHeader(header.getName(), header.getValue()));
        }
        ret.setPayload(request.getPayload());
        ret.getFetchOptions().setDeadline(Double.valueOf(5.0));
        return ret;
    }
}

