/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.maven.plugin.min;

import com.yahoo.platform.yui.compressor.CssCompressor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.apache.maven.plugin.logging.Log;
import org.b3log.maven.plugin.min.SourcesProcessor;

public final class CSSProcessor
extends SourcesProcessor {
    public CSSProcessor(Log logger, String srcDir, String targetDir, String suffix) {
        super(logger, srcDir, targetDir, suffix);
    }

    @Override
    protected void minimize() {
        if (null == this.getSrcDir()) {
            this.getLogger().error((CharSequence)"The source directory is null!");
            return;
        }
        try {
            File srcDir = this.getSrcDir();
            File[] srcFiles = srcDir.listFiles(file -> {
                String name = file.getName();
                return !file.isHidden() && !file.isDirectory() && name.endsWith(".css") && !name.endsWith(this.getSuffix() + ".css") && name.endsWith(".css");
            });
            for (int i = 0; i < srcFiles.length; ++i) {
                File src = srcFiles[i];
                String targetPath = this.getTargetDir() + File.separator + src.getName().substring(0, src.getName().length() - ".css".length()) + this.getSuffix() + ".css";
                File target = new File(targetPath);
                this.getLogger().info((CharSequence)("Minimizing [srcPath=" + src.getPath() + ", targetPath=" + targetPath + "]"));
                InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(src), "UTF-8");
                FileOutputStream writerStream = new FileOutputStream(target);
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)writerStream, "UTF-8");
                CssCompressor compressor = new CssCompressor((Reader)reader);
                compressor.compress((Writer)writer, -1);
                ((Reader)reader).close();
                ((Writer)writer).close();
            }
        }
        catch (IOException e) {
            this.getLogger().error((CharSequence)"Minimization error!", (Throwable)e);
        }
    }
}

