/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.maven.plugin.min;

import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.b3log.maven.plugin.min.JavaScriptErrorReporter;
import org.b3log.maven.plugin.min.SourcesProcessor;
import org.codehaus.plexus.util.IOUtil;
import org.mozilla.javascript.ErrorReporter;

public class JSProcessor
extends SourcesProcessor {
    private boolean munge;
    private boolean verbose;
    private boolean preserveAllSemiColons;
    private boolean disableOptimizations;
    private List<String> adminJSs;

    public JSProcessor(Log logger, String srcDir, String targetDir, String suffix, List<String> adminJSs) {
        super(logger, srcDir, targetDir, suffix);
        this.adminJSs = adminJSs;
    }

    @Override
    protected void minimize() {
        if (null == this.getSrcDir()) {
            this.getLogger().error((CharSequence)"The source directory is null!");
            return;
        }
        try {
            File srcDir = this.getSrcDir();
            this.processAdminJS(srcDir);
            File[] srcFiles = srcDir.listFiles(file -> {
                String name = file.getName();
                return !file.isHidden() && !file.isDirectory() && !name.endsWith(this.getSuffix() + ".js") && name.endsWith(".js");
            });
            for (int i = 0; i < srcFiles.length; ++i) {
                File src = srcFiles[i];
                String targetPath = this.getTargetDir() + File.separator + src.getName().substring(0, src.getName().length() - ".js".length()) + this.getSuffix() + ".js";
                File target = new File(targetPath);
                this.getLogger().info((CharSequence)("Minimizing [srcPath=" + src.getPath() + ", targetPath=" + targetPath + "]"));
                InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(src), "UTF-8");
                FileOutputStream writerStream = new FileOutputStream(target);
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)writerStream, "UTF-8");
                JavaScriptCompressor compressor = new JavaScriptCompressor((Reader)reader, (ErrorReporter)new JavaScriptErrorReporter(this.getLogger(), src.getName()));
                compressor.compress((Writer)writer, -1, this.munge, this.verbose, this.preserveAllSemiColons, this.disableOptimizations);
                ((Reader)reader).close();
                ((Writer)writer).close();
            }
        }
        catch (Exception e) {
            this.getLogger().error((CharSequence)"Minimization error!", (Throwable)e);
        }
    }

    private void processAdminJS(File srcDir) throws Exception {
        if (this.adminJSs.isEmpty()) {
            return;
        }
        File adminDir = new File(srcDir + File.separator + "admin");
        ArrayList<File> adminJSList = new ArrayList<File>();
        for (String adminJS : this.adminJSs) {
            File adminJSFile = new File(adminDir.getPath() + File.separator + adminJS);
            adminJSList.add(adminJSFile);
        }
        File latkeAdminJS = this.merge(adminJSList);
        File latkeMinAdminJS = new File(this.getTargetDir() + File.separator + "admin" + File.separator + "latkeAdmin" + this.getSuffix() + ".js");
        this.getLogger().info((CharSequence)("Minimizing [srcPath=" + latkeAdminJS.getPath() + ", targetPath=" + latkeMinAdminJS.getPath() + "]"));
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(latkeAdminJS), "UTF-8");
        FileOutputStream writerStream = new FileOutputStream(latkeMinAdminJS);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)writerStream, "UTF-8");
        JavaScriptCompressor compressor = new JavaScriptCompressor((Reader)reader, (ErrorReporter)new JavaScriptErrorReporter(this.getLogger(), latkeAdminJS.getName()));
        compressor.compress((Writer)writer, -1, this.munge, this.verbose, this.preserveAllSemiColons, this.disableOptimizations);
        ((Reader)reader).close();
        ((Writer)writer).close();
    }

    private File merge(List<File> files) throws Exception {
        if (files.isEmpty()) {
            return null;
        }
        File ret = new File(this.getTargetDir() + File.separator + "admin" + File.separator + "latkeAdmin.js");
        File adminTargetDir = new File(this.getTargetDir() + File.separator + "admin");
        if (!adminTargetDir.exists()) {
            adminTargetDir.mkdir();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(ret);
        StringBuilder sb = new StringBuilder("Merged [\r\n  ");
        for (int i = 0; i < files.size(); ++i) {
            FileInputStream fileInputStream = new FileInputStream(files.get(i));
            IOUtil.copy((InputStream)fileInputStream, (OutputStream)fileOutputStream);
            fileInputStream.close();
            sb.append(files.get(i).getPath());
            if (i >= files.size() - 1) continue;
            sb.append(",\r\n  ");
        }
        sb.append("\r\n], [").append(files.size()).append("] files");
        this.getLogger().info((CharSequence)sb.toString());
        fileOutputStream.close();
        return ret;
    }
}

