/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.maven.plugin.min;

import org.apache.maven.plugin.logging.Log;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;

public final class JavaScriptErrorReporter
implements ErrorReporter {
    private Log logger;
    private String filename;

    public JavaScriptErrorReporter(Log logger, String fileName) {
        this.logger = logger;
        this.filename = fileName;
    }

    public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
        if (line < 0) {
            this.logger.warn((CharSequence)message);
        } else {
            this.logger.warn((CharSequence)("[" + this.filename + ":" + line + "] " + message));
        }
    }

    public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
        if (line < 0) {
            this.logger.error((CharSequence)message);
        } else {
            this.logger.error((CharSequence)("[" + this.filename + ":" + line + "] " + message));
        }
    }

    public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
        this.error(message, sourceName, line, lineSource, lineOffset);
        return new EvaluatorException(message);
    }
}

