/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.dto;

import com.squareup.javapoet.ClassName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.Elements;
import org.babyfish.jimmer.apt.immutable.meta.ImmutableProp;
import org.babyfish.jimmer.apt.immutable.meta.ImmutableType;
import org.babyfish.jimmer.dto.compiler.DtoCompiler;
import org.babyfish.jimmer.dto.compiler.DtoFile;
import org.babyfish.jimmer.dto.compiler.DtoModifier;
import org.babyfish.jimmer.sql.GeneratedValue;

public class AptDtoCompiler
extends DtoCompiler<ImmutableType, ImmutableProp> {
    private static final ClassName STRING = ClassName.get(String.class);
    private final Elements elements;
    private final DtoModifier defaultNullableInputModifier;

    public AptDtoCompiler(DtoFile dtoFile, Elements elements, DtoModifier defaultNullableInputModifier) throws IOException {
        super(dtoFile);
        this.elements = elements;
        this.defaultNullableInputModifier = defaultNullableInputModifier;
    }

    public DtoModifier getDefaultNullableInputModifier() {
        return this.defaultNullableInputModifier;
    }

    protected Collection<ImmutableType> getSuperTypes(ImmutableType baseType) {
        return baseType.getSuperTypes();
    }

    protected Map<String, ImmutableProp> getDeclaredProps(ImmutableType baseType) {
        return baseType.getDeclaredProps();
    }

    protected Map<String, ImmutableProp> getProps(ImmutableType baseType) {
        return baseType.getProps();
    }

    protected ImmutableType getTargetType(ImmutableProp baseProp) {
        return baseProp.getTargetType();
    }

    protected boolean isGeneratedValue(ImmutableProp baseProp) {
        return baseProp.toElement().getAnnotation(GeneratedValue.class) != null;
    }

    protected boolean isStringProp(ImmutableProp baseProp) {
        return baseProp.getTypeName().equals((Object)STRING);
    }

    protected boolean isSameType(ImmutableProp baseProp1, ImmutableProp baseProp2) {
        return baseProp1.getClientTypeName().equals((Object)baseProp2.getClientTypeName());
    }

    protected List<String> getEnumConstants(ImmutableProp baseProp) {
        if (baseProp.isList() || !baseProp.context().isEnum(baseProp.getElementType())) {
            return null;
        }
        Element element = ((DeclaredType)baseProp.toElement().getReturnType()).asElement();
        if (!(element instanceof TypeElement)) {
            return null;
        }
        ArrayList<String> constants = new ArrayList<String>();
        for (Element element2 : element.getEnclosedElements()) {
            if (element2.getKind() != ElementKind.ENUM_CONSTANT) continue;
            constants.add(element2.getSimpleName().toString());
        }
        return constants;
    }

    protected Integer getGenericTypeCount(String qualifiedName) {
        TypeElement typeElement = this.elements.getTypeElement(qualifiedName);
        if (typeElement == null) {
            return null;
        }
        return typeElement.getTypeParameters().size();
    }
}

