/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.dto;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Filer;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import org.babyfish.jimmer.Immutable;
import org.babyfish.jimmer.apt.Context;
import org.babyfish.jimmer.apt.dto.AptDtoCompiler;
import org.babyfish.jimmer.apt.dto.DtoContext;
import org.babyfish.jimmer.apt.dto.DtoException;
import org.babyfish.jimmer.apt.dto.DtoGenerator;
import org.babyfish.jimmer.apt.immutable.meta.ImmutableProp;
import org.babyfish.jimmer.apt.immutable.meta.ImmutableType;
import org.babyfish.jimmer.dto.compiler.DtoAstException;
import org.babyfish.jimmer.dto.compiler.DtoFile;
import org.babyfish.jimmer.dto.compiler.DtoModifier;
import org.babyfish.jimmer.dto.compiler.DtoType;
import org.babyfish.jimmer.sql.Embeddable;
import org.babyfish.jimmer.sql.Entity;

public class DtoProcessor {
    private final Context context;
    private final Elements elements;
    private final Filer filer;
    private final Collection<String> dtoDirs;
    private final DtoModifier defaultNullableInputModifier;

    public DtoProcessor(Context context, Elements elements, Filer filer, Collection<String> dtoDirs, DtoModifier defaultNullableInputModifier) {
        this.context = context;
        this.elements = elements;
        this.filer = filer;
        this.dtoDirs = dtoDirs;
        this.defaultNullableInputModifier = defaultNullableInputModifier;
    }

    public boolean process() {
        Map<ImmutableType, List<DtoType<ImmutableType, ImmutableProp>>> dtoTypeMap = this.parseDtoTypes();
        return this.generateDtoTypes(dtoTypeMap);
    }

    private Map<ImmutableType, List<DtoType<ImmutableType, ImmutableProp>>> parseDtoTypes() {
        LinkedHashMap<ImmutableType, List<DtoType<ImmutableType, ImmutableProp>>> dtoTypeMap = new LinkedHashMap<ImmutableType, List<DtoType<ImmutableType, ImmutableProp>>>();
        DtoContext dtoContext = new DtoContext(this.filer, this.dtoDirs);
        for (DtoFile dtoFile : dtoContext.getDtoFiles()) {
            AptDtoCompiler compiler;
            try {
                compiler = new AptDtoCompiler(dtoFile, this.elements, this.defaultNullableInputModifier);
            }
            catch (DtoAstException ex) {
                throw new DtoException("Failed to parse \"" + dtoFile.getAbsolutePath() + "\": " + ex.getMessage(), ex);
            }
            catch (Throwable ex) {
                throw new DtoException("Failed to read \"" + dtoFile.getAbsolutePath() + "\": " + ex.getMessage(), ex);
            }
            TypeElement typeElement = this.elements.getTypeElement(compiler.getSourceTypeName());
            if (typeElement == null) {
                throw new DtoException("Failed to parse \"" + dtoFile.getAbsolutePath() + "\": No immutable type \"" + compiler.getSourceTypeName() + "\"");
            }
            if (!this.context.include(typeElement)) continue;
            if (typeElement.getAnnotation(Entity.class) == null && typeElement.getAnnotation(Embeddable.class) == null && typeElement.getAnnotation(Immutable.class) == null) {
                throw new DtoException("Failed to parse \"" + dtoFile.getAbsolutePath() + "\": the \"" + compiler.getSourceTypeName() + "\" is not decorated by \"@" + Entity.class.getName() + "\", \"" + Embeddable.class.getName() + "\" or \"" + Immutable.class.getName() + "\"");
            }
            ImmutableType immutableType = this.context.getImmutableType(typeElement);
            dtoTypeMap.computeIfAbsent(immutableType, it -> new ArrayList()).addAll(compiler.compile(immutableType));
        }
        return dtoTypeMap;
    }

    private boolean generateDtoTypes(Map<?, List<DtoType<ImmutableType, ImmutableProp>>> dtoTypeMap) {
        boolean result = false;
        for (List<DtoType<ImmutableType, ImmutableProp>> dtoTypes : dtoTypeMap.values()) {
            for (DtoType<ImmutableType, ImmutableProp> dtoType : dtoTypes) {
                new DtoGenerator(this.context, dtoType, this.filer).generate();
                result = true;
            }
        }
        return result;
    }
}

