/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.entry;

import java.util.Collection;
import java.util.Map;
import javax.annotation.processing.Filer;
import javax.lang.model.element.TypeElement;
import org.babyfish.jimmer.Immutable;
import org.babyfish.jimmer.apt.Context;
import org.babyfish.jimmer.apt.entry.FetchersGenerator;
import org.babyfish.jimmer.apt.entry.IndexFileGenerator;
import org.babyfish.jimmer.apt.entry.ObjectsGenerator;
import org.babyfish.jimmer.apt.entry.PackageCollector;
import org.babyfish.jimmer.apt.entry.TablesGenerator;
import org.babyfish.jimmer.sql.Embeddable;
import org.babyfish.jimmer.sql.Entity;
import org.babyfish.jimmer.sql.MappedSuperclass;

public class EntryProcessor {
    private final Context context;
    private final Collection<TypeElement> typeElements;
    private final Filer filer;

    public EntryProcessor(Context context, Collection<TypeElement> typeElements, Filer filer) {
        this.context = context;
        this.typeElements = typeElements;
        this.filer = filer;
    }

    public void process() {
        PackageCollector packageCollector = new PackageCollector();
        IndexFileGenerator entityGenerator = new IndexFileGenerator(this.context, this.typeElements, this.filer, packageCollector){

            @Override
            protected String getListFilePath() {
                return "META-INF/jimmer/entities";
            }

            @Override
            protected boolean isManaged(TypeElement typeElement, boolean strict) {
                if (strict) {
                    return typeElement.getAnnotation(Entity.class) != null;
                }
                return typeElement.getAnnotation(MappedSuperclass.class) == null && this.context.isImmutable(typeElement);
            }
        };
        IndexFileGenerator immutableGenerator = new IndexFileGenerator(this.context, this.typeElements, this.filer, packageCollector){

            @Override
            protected String getListFilePath() {
                return "META-INF/jimmer/immutables";
            }

            @Override
            protected boolean isManaged(TypeElement typeElement, boolean strict) {
                if (strict) {
                    return typeElement.getAnnotation(Immutable.class) != null || typeElement.getAnnotation(Embeddable.class) != null;
                }
                return typeElement.getAnnotation(MappedSuperclass.class) == null && this.context.isImmutable(typeElement);
            }
        };
        String packageName = packageCollector.toString();
        Map<String, TypeElement> allElementMap = packageCollector.getElementMap();
        Map<String, TypeElement> entityElementMap = entityGenerator.getElementMap();
        entityGenerator.generate();
        immutableGenerator.generate();
        if (!allElementMap.isEmpty()) {
            new ObjectsGenerator(packageName, this.context.getObjectsTypeName(), allElementMap.values(), this.filer).generate();
        }
        if (!entityElementMap.isEmpty()) {
            new TablesGenerator(packageName, this.context.getTablesTypeName(), entityElementMap.values(), this.filer, false).generate();
            new TablesGenerator(packageName, this.context.getTableExesTypeName(), entityElementMap.values(), this.filer, true).generate();
            new FetchersGenerator(packageName, this.context.getFetchersTypeName(), entityElementMap.values(), this.filer).generate();
        }
    }
}

