/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.immutable.generator;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.MethodSpec;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.babyfish.jimmer.apt.immutable.meta.ImmutableProp;

public class Annotations {
    private static final String JAVAX_PREFIX = "javax.validation.constraints.";
    private static final String JAKARTA_PREFIX = "jakarta.validation.constraints.";

    private Annotations() {
    }

    public static Map<String, List<AnnotationMirror>> validateAnnotationMirrorMultiMap(ImmutableProp prop) {
        HashMap<String, List<AnnotationMirror>> mirrorMultiMap = new HashMap<String, List<AnnotationMirror>>();
        for (AnnotationMirror annotationMirror : prop.getAnnotations()) {
            String name;
            Element element = annotationMirror.getAnnotationType().asElement();
            if (!(element instanceof TypeElement)) continue;
            String qualifiedName = ((TypeElement)element).getQualifiedName().toString();
            if (qualifiedName.startsWith(JAVAX_PREFIX)) {
                name = qualifiedName.substring(JAVAX_PREFIX.length());
                mirrorMultiMap.computeIfAbsent(name, it -> new ArrayList()).add(annotationMirror);
                continue;
            }
            if (!qualifiedName.startsWith(JAKARTA_PREFIX)) continue;
            name = qualifiedName.substring(JAKARTA_PREFIX.length());
            mirrorMultiMap.computeIfAbsent(name, it -> new ArrayList()).add(annotationMirror);
        }
        return mirrorMultiMap;
    }

    public static AnnotationMirror annotationMirror(Element element, Class<? extends Annotation> annotationType) {
        return Annotations.annotationMirror(element, annotationType.getName());
    }

    public static AnnotationMirror annotationMirror(Element element, String qualifiedName) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            TypeElement typeElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!typeElement.getQualifiedName().toString().equals(qualifiedName)) continue;
            return annotationMirror;
        }
        return null;
    }

    public static AnnotationMirror annotationMirror(TypeMirror typeMirror, Class<? extends Annotation> annotationType) {
        String qualifiedName = annotationType.getName();
        for (AnnotationMirror annotationMirror : typeMirror.getAnnotationMirrors()) {
            TypeElement typeElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!typeElement.getQualifiedName().toString().equals(qualifiedName)) continue;
            return annotationMirror;
        }
        return null;
    }

    public static String qualifiedName(AnnotationMirror mirror) {
        return ((TypeElement)mirror.getAnnotationType().asElement()).getQualifiedName().toString();
    }

    public static <T> T annotationValue(AnnotationMirror mirror, String name, T defaultValue) {
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> e : mirror.getElementValues().entrySet()) {
            if (!e.getKey().getSimpleName().toString().equals(name)) continue;
            return (T)e.getValue().getValue();
        }
        return defaultValue;
    }

    public static <T> List<T> nonNullList(List<T> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public static void copyNonJimmerAnnotations(MethodSpec.Builder builder, Collection<? extends AnnotationMirror> annotations) {
        for (AnnotationMirror annotationMirror : annotations) {
            TypeElement typeElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (typeElement.getQualifiedName().toString().startsWith("org.babyfish.jimmer.")) continue;
            builder.addAnnotation(AnnotationSpec.get((AnnotationMirror)annotationMirror));
        }
    }
}

