/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.immutable.generator;

import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Objects;
import javax.lang.model.element.Modifier;
import org.babyfish.jimmer.apt.immutable.meta.ImmutableProp;
import org.babyfish.jimmer.impl.util.StringUtil;
import org.babyfish.jimmer.lang.OldChain;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AssociatedIdGenerator {
    private final TypeSpec.Builder typeBuilder;
    private final boolean withImplementation;

    public AssociatedIdGenerator(TypeSpec.Builder typeBuilder, boolean withImplementation) {
        this.typeBuilder = typeBuilder;
        this.withImplementation = withImplementation;
    }

    void getter(ImmutableProp prop) {
        if (AssociatedIdGenerator.skip(prop)) {
            return;
        }
        TypeName idTypeName = prop.getTargetType().getIdProp().getTypeName();
        if (prop.isNullable()) {
            idTypeName = idTypeName.box();
        }
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)StringUtil.identifier((String[])new String[]{prop.getGetterName(), "Id"})).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(idTypeName);
        if (!idTypeName.isPrimitive()) {
            builder.addAnnotation(prop.isNullable() ? Nullable.class : NotNull.class);
        }
        if (!this.withImplementation) {
            builder.addModifiers(new Modifier[]{Modifier.ABSTRACT});
        } else {
            builder.addAnnotation(Override.class);
            if (prop.isNullable()) {
                builder.addStatement("$T $L = $L()", new Object[]{prop.getTargetType().getClassName(), prop.getName(), prop.getGetterName()});
                builder.beginControlFlow("if ($L == null)", new Object[]{prop.getName()});
                builder.addStatement("return null", new Object[0]);
                builder.endControlFlow();
                builder.addStatement("return $L.$L()", new Object[]{prop.getName(), prop.getTargetType().getIdProp().getGetterName()});
            } else {
                builder.addStatement("return $L().$L()", new Object[]{prop.getGetterName(), prop.getTargetType().getIdProp().getGetterName()});
            }
        }
        this.typeBuilder.addMethod(builder.build());
    }

    void setter(ImmutableProp prop) {
        if (AssociatedIdGenerator.skip(prop)) {
            return;
        }
        TypeName idTypeName = prop.getTargetType().getIdProp().getTypeName();
        if (prop.isNullable()) {
            idTypeName = idTypeName.box();
        }
        String parameterName = StringUtil.identifier((String[])new String[]{prop.getName(), "Id"});
        ParameterSpec.Builder parameterBuilder = ParameterSpec.builder((TypeName)idTypeName, (String)parameterName, (Modifier[])new Modifier[0]);
        if (!idTypeName.isPrimitive()) {
            parameterBuilder.addAnnotation(prop.isNullable() ? Nullable.class : NotNull.class);
        }
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)StringUtil.identifier((String[])new String[]{prop.getSetterName(), "Id"})).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(parameterBuilder.build()).returns((TypeName)prop.getDeclaringType().getDraftClassName()).addAnnotation(OldChain.class);
        if (!this.withImplementation) {
            builder.addModifiers(new Modifier[]{Modifier.ABSTRACT});
        } else {
            builder.addAnnotation(Override.class);
            if (prop.isNullable()) {
                builder.beginControlFlow("if ($L == null)", new Object[]{parameterName});
                builder.addStatement("$L(null)", new Object[]{prop.getSetterName()});
                builder.addStatement("return this", new Object[0]);
                builder.endControlFlow();
                builder.addStatement("$L(true).$L($L)", new Object[]{prop.getGetterName(), prop.getTargetType().getIdProp().getSetterName(), parameterName});
            } else if (prop.getTypeName().isPrimitive()) {
                builder.addStatement("$L(true).$L($L)", new Object[]{prop.getGetterName(), prop.getTargetType().getIdProp().getSetterName(), parameterName});
            } else {
                builder.addStatement("$L(true).$L($T.requireNonNull($L, $S))", new Object[]{prop.getGetterName(), prop.getTargetType().getIdProp().getSetterName(), Objects.class, parameterName, "\"" + prop.getName() + "\" cannot be null"});
            }
            builder.addStatement("return this", new Object[0]);
        }
        this.typeBuilder.addMethod(builder.build());
    }

    private static boolean skip(ImmutableProp prop) {
        return !prop.isAssociation(true) || prop.isList() || prop.getIdViewProp() != null || prop.getDeclaringType().getProps().containsKey(StringUtil.identifier((String[])new String[]{prop.getName(), "Id"}));
    }
}

