/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.immutable.meta;

import com.squareup.javapoet.ClassName;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.validation.Constraint;
import org.babyfish.jimmer.apt.MetaException;

public class ValidationMessages {
    public static final String CONSTRAINT_FULL_NAME = Constraint.class.getName();

    private ValidationMessages() {
    }

    public static Map<ClassName, String> parseMessageMap(Element element) {
        LinkedHashMap<ClassName, String> map = new LinkedHashMap<ClassName, String>();
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!ValidationMessages.hasConstraint((TypeElement)annotationMirror.getAnnotationType().asElement())) continue;
            TypeElement typeElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
            ClassName className = ClassName.get((String)((PackageElement)typeElement.getEnclosingElement()).getQualifiedName().toString(), (String)typeElement.getSimpleName().toString(), (String[])new String[0]);
            if (map.containsKey(className)) {
                throw new MetaException(element, "duplicate annotations \"" + className + "\"");
            }
            String message = "";
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> e : annotationMirror.getElementValues().entrySet()) {
                if (!e.getKey().getSimpleName().toString().equals("message")) continue;
                Object msg = e.getValue().getValue();
                if (!(msg instanceof String)) break;
                message = (String)msg;
                break;
            }
            map.put(className, message);
        }
        return Collections.unmodifiableMap(map);
    }

    private static boolean hasConstraint(TypeElement element) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            TypeElement annoElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!annoElement.getQualifiedName().toString().equals(CONSTRAINT_FULL_NAME)) continue;
            Retention retention = element.getAnnotation(Retention.class);
            if (retention == null || retention.value() != RetentionPolicy.RUNTIME) {
                throw new MetaException(element, "the annotation @" + element.getQualifiedName().toString() + " is decorated by @" + Constraint.class.getName() + " but its retention is not runtime");
            }
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> e : annotationMirror.getElementValues().entrySet()) {
                if (!e.getKey().getSimpleName().toString().equals("validatedBy")) continue;
                return !((Collection)e.getValue().getValue()).isEmpty();
            }
        }
        return false;
    }
}

