/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.generator.ts;

import java.io.Writer;
import java.util.List;
import org.babyfish.jimmer.client.generator.CodeWriter;
import org.babyfish.jimmer.client.generator.Context;
import org.babyfish.jimmer.client.generator.SourceWriter;
import org.babyfish.jimmer.client.generator.ts.EnumTypeRender;
import org.babyfish.jimmer.client.generator.ts.NullRenderMode;
import org.babyfish.jimmer.client.generator.ts.TypeScriptSourceManager;
import org.babyfish.jimmer.client.generator.ts.TypeScriptWriter;
import org.babyfish.jimmer.client.runtime.Metadata;
import org.babyfish.jimmer.client.source.Source;
import org.babyfish.jimmer.client.source.SourceManager;

public class TypeScriptContext
extends Context {
    private final boolean isMutable;
    private final String apiName;
    private final NullRenderMode nullRenderMode;
    private final boolean isEnumTsStyle;

    public TypeScriptContext(Metadata metadata) {
        this(metadata, 4, false, null, NullRenderMode.UNDEFINED, false);
    }

    public TypeScriptContext(Metadata metadata, int indent, boolean isMutable, String apiName, NullRenderMode nullRenderMode, boolean isEnumTsStyle) {
        super(metadata, TypeScriptContext.indent(indent));
        if (!metadata.isGenericSupported()) {
            throw new IllegalArgumentException("TypeScriptContext only accept metadata which support generic");
        }
        this.isMutable = isMutable;
        this.apiName = apiName != null && !apiName.isEmpty() ? apiName : "Api";
        this.nullRenderMode = nullRenderMode != null ? nullRenderMode : NullRenderMode.UNDEFINED;
        this.isEnumTsStyle = isEnumTsStyle;
    }

    public boolean isMutable() {
        return this.isMutable;
    }

    public String getApiName() {
        return this.apiName;
    }

    public NullRenderMode getNullRenderMode() {
        return this.nullRenderMode;
    }

    public boolean isEnumTsStyle() {
        return this.isEnumTsStyle;
    }

    @Override
    protected SourceManager createSourceManager() {
        return new TypeScriptSourceManager(this);
    }

    @Override
    protected SourceWriter createCodeWriter(Context context, Source source) {
        return new TypeScriptWriter(context, source);
    }

    @Override
    protected boolean isIndexRequired() {
        return true;
    }

    @Override
    protected void renderIndexCode(String dir, List<Source> sources, Writer writer) {
        if (!dir.equals("model/enums")) {
            return;
        }
        EnumConstantWriter ecw = new EnumConstantWriter(writer, this.getIndent());
        for (Source source : sources) {
            if (!(source.getRender() instanceof EnumTypeRender)) continue;
            ((EnumConstantWriter)((EnumConstantWriter)((EnumConstantWriter)((EnumConstantWriter)((EnumConstantWriter)((EnumConstantWriter)ecw.code("import { ")).code(source.getName())).code("_CONSTANTS")).codeIf(this.isEnumTsStyle, ", " + source.getName() + "_CONSTANT_MAP")).code(" } from './")).code(source.getName())).code("';\n");
        }
        ecw.code("export const ALL_ENUM_CONSTANTS = ");
        ecw.scope(CodeWriter.ScopeType.OBJECT, ", ", true, () -> {
            for (Source source : sources) {
                if (!(source.getRender() instanceof EnumTypeRender)) continue;
                ecw.separator();
                ((EnumConstantWriter)((EnumConstantWriter)((EnumConstantWriter)((EnumConstantWriter)ecw.code('\"')).code(source.getName())).code("\": ")).code(source.getName())).code("_CONSTANTS");
            }
        });
        ecw.code('\n');
        if (this.isEnumTsStyle) {
            ecw.code("export const ALL_ENUM_CONSTANT_MAPS = ");
            ecw.scope(CodeWriter.ScopeType.OBJECT, ", ", true, () -> {
                for (Source source : sources) {
                    if (!(source.getRender() instanceof EnumTypeRender)) continue;
                    ecw.separator();
                    ((EnumConstantWriter)((EnumConstantWriter)((EnumConstantWriter)((EnumConstantWriter)ecw.code('\"')).code(source.getName())).code("\": ")).code(source.getName())).code("_CONSTANT_MAP");
                }
            });
            ecw.code('\n');
        }
    }

    @Override
    protected String getFileExtension() {
        return "ts";
    }

    public static Builder newBuilder(Metadata metadata) {
        return new Builder(metadata);
    }

    private static class EnumConstantWriter
    extends CodeWriter<EnumConstantWriter> {
        public EnumConstantWriter(Writer writer, String indent) {
            super(indent);
            this.setWriter(writer);
        }
    }

    public static class Builder {
        private final Metadata metadata;
        private int indent;
        private boolean isMutable;
        private String apiName;
        private NullRenderMode nullRenderMode;
        private boolean isEnumTsStyle;

        public Builder(Metadata metadata) {
            this.metadata = metadata;
        }

        public Builder setMutable(boolean mutable) {
            this.isMutable = mutable;
            return this;
        }

        public Builder setIndent(int indent) {
            this.indent = indent;
            return this;
        }

        public Builder setApiName(String apiName) {
            this.apiName = apiName;
            return this;
        }

        public Builder setNullRenderMode(NullRenderMode nullRenderMode) {
            this.nullRenderMode = nullRenderMode;
            return this;
        }

        public Builder setEnumTsStyle(boolean enumTsStyle) {
            this.isEnumTsStyle = enumTsStyle;
            return this;
        }

        public TypeScriptContext build() {
            return new TypeScriptContext(this.metadata, this.indent, this.isMutable, this.apiName, this.nullRenderMode, this.isEnumTsStyle);
        }
    }
}

