/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.runtime.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.babyfish.jimmer.client.meta.Doc;
import org.babyfish.jimmer.client.meta.EnumConstant;
import org.babyfish.jimmer.client.meta.TypeDefinition;
import org.babyfish.jimmer.client.runtime.EnumType;
import org.babyfish.jimmer.client.runtime.impl.Graph;
import org.jetbrains.annotations.Nullable;

public class EnumTypeImpl
extends Graph
implements EnumType {
    private final Class<?> javaType;
    private final List<String> simpleNames;
    private final List<EnumType.Constant> constants;
    private final Doc doc;

    public EnumTypeImpl(Class<?> javaType, TypeDefinition definition) {
        this.javaType = javaType;
        ArrayList<String> simpleNames = new ArrayList<String>();
        for (Class<?> type = javaType; type != null; type = type.getDeclaringClass()) {
            simpleNames.add(0, type.getSimpleName());
        }
        this.simpleNames = Collections.unmodifiableList(simpleNames);
        ArrayList<EnumType.Constant> constants = new ArrayList<EnumType.Constant>();
        for (EnumConstant constant : definition.getEnumConstantMap().values()) {
            constants.add(new EnumType.Constant(constant.getName(), constant.getDoc()));
        }
        this.constants = Collections.unmodifiableList(constants);
        this.doc = definition.getDoc();
    }

    @Override
    public Class<?> getJavaType() {
        return this.javaType;
    }

    @Override
    public List<String> getSimpleNames() {
        return this.simpleNames;
    }

    @Override
    public List<EnumType.Constant> getConstants() {
        return this.constants;
    }

    @Override
    @Nullable
    public Doc getDoc() {
        return this.doc;
    }

    @Override
    protected String toStringImpl(Set<Graph> stack) {
        return this.javaType.getName();
    }
}

