/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.runtime.impl;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.babyfish.jimmer.client.meta.Doc;
import org.babyfish.jimmer.client.meta.TypeDefinition;
import org.babyfish.jimmer.client.runtime.FetchByInfo;
import org.babyfish.jimmer.client.runtime.ObjectType;
import org.babyfish.jimmer.client.runtime.Property;
import org.babyfish.jimmer.client.runtime.Type;
import org.babyfish.jimmer.client.runtime.impl.Graph;
import org.babyfish.jimmer.client.runtime.impl.StaticObjectTypeImpl;
import org.babyfish.jimmer.meta.ImmutableType;
import org.jetbrains.annotations.Nullable;

public class GenericTypeImpl
extends Graph
implements ObjectType {
    private final StaticObjectTypeImpl raw;
    private final List<Type> arguments;

    public GenericTypeImpl(StaticObjectTypeImpl raw, List<Type> arguments) {
        if (arguments.isEmpty()) {
            throw new IllegalArgumentException("argument cannot be empty");
        }
        this.raw = raw;
        this.arguments = arguments;
    }

    @Override
    public Class<?> getJavaType() {
        return this.raw.getJavaType();
    }

    @Override
    @Nullable
    public ImmutableType getImmutableType() {
        return this.raw.getImmutableType();
    }

    @Override
    public ObjectType.Kind getKind() {
        return ObjectType.Kind.STATIC;
    }

    @Override
    public List<String> getSimpleNames() {
        return this.raw.getSimpleNames();
    }

    @Override
    @Nullable
    public FetchByInfo getFetchByInfo() {
        return this.raw.getFetchByInfo();
    }

    @Override
    public List<Type> getArguments() {
        return this.arguments;
    }

    @Override
    @Nullable
    public Doc getDoc() {
        return this.raw.getDoc();
    }

    @Override
    @Nullable
    public TypeDefinition.Error getError() {
        return this.raw.getError();
    }

    @Override
    public Map<String, Property> getProperties() {
        return this.raw.getProperties();
    }

    @Override
    public boolean isRecursiveFetchedType() {
        return false;
    }

    @Override
    public boolean hasMultipleRecursiveProps() {
        return false;
    }

    @Override
    public ObjectType unwrap() {
        return this.raw;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericTypeImpl that = (GenericTypeImpl)o;
        if (!this.raw.equals(that.raw)) {
            return false;
        }
        return this.arguments.equals(that.arguments);
    }

    public int hashCode() {
        int result = this.raw.hashCode();
        result = 31 * result + this.arguments.hashCode();
        return result;
    }

    @Override
    protected String toStringImpl(Set<Graph> stack) {
        Class<?> javaType = this.getJavaType();
        Map<String, Property> properties = this.getProperties();
        return javaType.getName() + '<' + this.arguments.stream().map(it -> GenericTypeImpl.string(it, stack)).collect(Collectors.joining(", ")) + "> {" + properties.values().stream().map(it -> GenericTypeImpl.string(it, stack)).collect(Collectors.joining(", ")) + '}';
    }
}

