/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.runtime.impl;

import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.babyfish.jimmer.client.meta.TypeName;
import org.babyfish.jimmer.client.runtime.SimpleType;
import org.babyfish.jimmer.client.runtime.impl.Graph;

public class SimpleTypeImpl
extends Graph
implements SimpleType {
    private static final Map<TypeName, SimpleType> MAP = new WeakHashMap<TypeName, SimpleType>();
    private final Class<?> javaType;

    private SimpleTypeImpl(Class<?> javaType) {
        this.javaType = javaType;
    }

    @Override
    public Class<?> getJavaType() {
        return this.javaType;
    }

    public static SimpleType of(TypeName typeName) {
        return MAP.computeIfAbsent(typeName, it -> {
            Class<?> javaType;
            if (typeName.isGenerationRequired()) {
                throw new IllegalArgumentException("The type name \"" + typeName + "\" is not simple type");
            }
            switch (typeName.toString()) {
                case "boolean": {
                    return new SimpleTypeImpl(Boolean.TYPE);
                }
                case "char": {
                    return new SimpleTypeImpl(Character.TYPE);
                }
                case "byte": {
                    return new SimpleTypeImpl(Byte.TYPE);
                }
                case "short": {
                    return new SimpleTypeImpl(Short.TYPE);
                }
                case "int": {
                    return new SimpleTypeImpl(Integer.TYPE);
                }
                case "long": {
                    return new SimpleTypeImpl(Long.TYPE);
                }
                case "float": {
                    return new SimpleTypeImpl(Float.TYPE);
                }
                case "double": {
                    return new SimpleTypeImpl(Double.TYPE);
                }
            }
            try {
                javaType = Class.forName(typeName.toString());
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException("No java type \"" + typeName + "\"", ex);
            }
            return new SimpleTypeImpl(javaType);
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleTypeImpl that = (SimpleTypeImpl)o;
        return this.javaType.equals(that.javaType);
    }

    public int hashCode() {
        return this.javaType.hashCode();
    }

    @Override
    protected String toStringImpl(Set<Graph> stack) {
        return this.javaType.getName();
    }
}

