/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.source;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Supplier;
import org.babyfish.jimmer.client.generator.Render;
import org.babyfish.jimmer.client.source.Source;

abstract class AbstractSource
implements Source {
    private final Render render;
    private Map<String, Source> subSourceMap;

    AbstractSource(Render render) {
        this.render = Objects.requireNonNull(render, "render cannot be null");
    }

    @Override
    public Source subSource(String name, Supplier<Render> renderCreator) {
        Source subSource;
        Map<String, Source> subSourceMap = this.subSourceMap;
        if (subSourceMap == null) {
            this.subSourceMap = subSourceMap = new TreeMap<String, Source>();
        }
        if ((subSource = subSourceMap.get(name)) == null) {
            subSource = new SubSource(name, renderCreator.get());
            subSourceMap.put(name, subSource);
        }
        return subSource;
    }

    @Override
    public Collection<Source> getSubSources() {
        if (this.subSourceMap == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.subSourceMap.values());
    }

    @Override
    public Render getRender() {
        return this.render;
    }

    public int hashCode() {
        return this.getDirs().hashCode() ^ this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AbstractSource)) {
            return false;
        }
        AbstractSource other = (AbstractSource)obj;
        return this.getDirs().equals(other.getDirs()) && this.getName().equals(other.getName());
    }

    public String toString() {
        return AbstractSource.toString(this.getDirs(), this.getName());
    }

    static String toString(List<String> dirs, String name) {
        if (dirs == null || dirs.isEmpty()) {
            return name;
        }
        return String.join((CharSequence)"/", dirs) + '/' + name;
    }

    private class SubSource
    extends AbstractSource {
        private final String name;
        private final Source root;

        private SubSource(String name, Render render) {
            super(render);
            this.name = name;
            this.root = AbstractSource.this.getRoot();
        }

        @Override
        public List<String> getDirs() {
            return AbstractSource.this.getDirs();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Source getParent() {
            return AbstractSource.this;
        }

        @Override
        public Source getRoot() {
            return this.root;
        }
    }
}

