/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.association.meta;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import org.babyfish.jimmer.jackson.Converter;
import org.babyfish.jimmer.jackson.ConverterMetadata;
import org.babyfish.jimmer.lang.Ref;
import org.babyfish.jimmer.meta.Dependency;
import org.babyfish.jimmer.meta.EmbeddedLevel;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutablePropCategory;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.OrderedItem;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.sql.DissociateAction;
import org.babyfish.jimmer.sql.ManyToOne;
import org.babyfish.jimmer.sql.association.Association;
import org.babyfish.jimmer.sql.association.meta.AssociationType;
import org.babyfish.jimmer.sql.meta.ColumnDefinition;
import org.babyfish.jimmer.sql.meta.LogicalDeletedValueGenerator;
import org.babyfish.jimmer.sql.meta.MetadataStrategy;
import org.babyfish.jimmer.sql.meta.SqlContext;
import org.babyfish.jimmer.sql.meta.SqlTemplate;
import org.babyfish.jimmer.sql.meta.Storage;
import org.jetbrains.annotations.NotNull;

public abstract class AssociationProp
implements ImmutableProp {
    final AssociationType declaringType;

    AssociationProp(AssociationType declaringType) {
        this.declaringType = declaringType;
    }

    @NotNull
    public AssociationType getDeclaringType() {
        return this.declaringType;
    }

    @NotNull
    public ImmutablePropCategory getCategory() {
        return ImmutablePropCategory.REFERENCE;
    }

    @NotNull
    public Class<?> getReturnClass() {
        return this.getElementClass();
    }

    @NotNull
    public Type getGenericType() {
        return this.getElementClass();
    }

    @NotNull
    public DissociateAction getDissociateAction() {
        return DissociateAction.NONE;
    }

    public boolean isEmbedded(EmbeddedLevel level) {
        return level.hasReference() && this.getTargetType().getIdProp().isEmbedded(EmbeddedLevel.SCALAR);
    }

    public boolean isAssociation(TargetLevel level) {
        return true;
    }

    public boolean isReference(TargetLevel level) {
        return true;
    }

    public boolean isScalar(TargetLevel level) {
        return false;
    }

    public boolean isScalarList() {
        return false;
    }

    public boolean isReferenceList(TargetLevel level) {
        return false;
    }

    public boolean isNullable() {
        return false;
    }

    public boolean isInputNotNull() {
        return true;
    }

    public boolean isMutable() {
        return true;
    }

    public Annotation getAssociationAnnotation() {
        return null;
    }

    public Class<? extends Annotation> getPrimaryAnnotationType() {
        return ManyToOne.class;
    }

    public boolean isTransient() {
        return false;
    }

    public boolean hasTransientResolver() {
        return false;
    }

    public boolean isFormula() {
        return false;
    }

    public boolean isTargetForeignKeyReal(MetadataStrategy strategy) {
        return true;
    }

    public <S extends Storage> S getStorage(MetadataStrategy strategy) {
        return null;
    }

    public SqlTemplate getSqlTemplate() {
        return null;
    }

    public boolean isView() {
        return false;
    }

    public ImmutableProp getIdViewProp() {
        return null;
    }

    public ImmutableProp getIdViewBaseProp() {
        return null;
    }

    public ImmutableProp getManyToManyViewBaseProp() {
        return null;
    }

    public ImmutableProp getManyToManyViewBaseDeeperProp() {
        return null;
    }

    public ConverterMetadata getConverterMetadata() {
        return null;
    }

    public <S, T> Converter<S, T> getConverter() {
        return null;
    }

    public <S, T> Converter<S, T> getConverter(boolean forList) {
        return null;
    }

    public <S, T> Converter<S, T> getAssociatedIdConverter(boolean forList) {
        return null;
    }

    public LogicalDeletedValueGenerator<?> getLogicalDeletedValueGenerator(SqlContext sqlContext) {
        return null;
    }

    public boolean isId() {
        return false;
    }

    public boolean isVersion() {
        return false;
    }

    public boolean isLogicalDeleted() {
        return false;
    }

    public ImmutableProp getMappedBy() {
        return null;
    }

    public ImmutableProp getOpposite() {
        return null;
    }

    public ImmutableProp getReal() {
        return this;
    }

    public List<Dependency> getDependencies() {
        return Collections.emptyList();
    }

    public List<ImmutableProp> getPropsDependOnSelf() {
        return Collections.emptyList();
    }

    public Ref<Object> getDefaultValueRef() {
        return null;
    }

    public boolean isExcludedFromAllScalars() {
        return false;
    }

    public List<OrderedItem> getOrderedItems() {
        return Collections.emptyList();
    }

    public boolean isRemote() {
        return false;
    }

    public ImmutableProp toOriginal() {
        return this;
    }

    public boolean hasStorage() {
        return true;
    }

    public boolean isColumnDefinition() {
        return true;
    }

    public boolean isMiddleTableDefinition() {
        return false;
    }

    public String toString() {
        return (Object)((Object)this.declaringType) + "." + this.getName();
    }

    static class Target
    extends AssociationProp {
        private static final Method GETTER;

        Target(AssociationType declaringType) {
            super(declaringType);
        }

        public PropId getId() {
            return PropId.byIndex((int)1);
        }

        @NotNull
        public String getName() {
            return "target";
        }

        @NotNull
        public Class<?> getElementClass() {
            return this.declaringType.getTargetType().getJavaClass();
        }

        public ImmutableType getTargetType() {
            return this.declaringType.getTargetType();
        }

        public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
            return GETTER.getAnnotation(annotationType);
        }

        public <A extends Annotation> A[] getAnnotations(Class<A> annotationType) {
            return GETTER.getAnnotationsByType(annotationType);
        }

        public Annotation[] getAnnotations() {
            return GETTER.getAnnotations();
        }

        public ColumnDefinition getStorage(MetadataStrategy strategy) {
            return this.declaringType.getMiddleTable(strategy).getTargetColumnDefinition();
        }

        static {
            try {
                GETTER = Association.class.getMethod("target", new Class[0]);
            }
            catch (NoSuchMethodException ex) {
                throw new AssertionError((Object)"Internal bug: Cannot get Association.source");
            }
        }
    }

    static class Source
    extends AssociationProp {
        private static final Method GETTER;

        Source(AssociationType declaringType) {
            super(declaringType);
        }

        public PropId getId() {
            return PropId.byIndex((int)0);
        }

        @NotNull
        public String getName() {
            return "source";
        }

        @NotNull
        public Class<?> getElementClass() {
            return this.declaringType.getSourceType().getJavaClass();
        }

        public ImmutableType getTargetType() {
            return this.declaringType.getSourceType();
        }

        public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
            return GETTER.getAnnotation(annotationType);
        }

        public <A extends Annotation> A[] getAnnotations(Class<A> annotationType) {
            return GETTER.getAnnotationsByType(annotationType);
        }

        public Annotation[] getAnnotations() {
            return GETTER.getAnnotations();
        }

        public ColumnDefinition getStorage(MetadataStrategy strategy) {
            return this.declaringType.getMiddleTable(strategy).getColumnDefinition();
        }

        static {
            try {
                GETTER = Association.class.getMethod("source", new Class[0]);
            }
            catch (NoSuchMethodException ex) {
                throw new AssertionError((Object)"Internal bug: Cannot get Association.source");
            }
        }
    }
}

