/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl;

import java.util.Collection;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.ExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.query.MutableStatementImplementor;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;

public abstract class AbstractExpression<T>
implements ExpressionImplementor<T>,
Ast {
    private boolean isLowestPrecedenceUsing = false;
    private Boolean hasVirtualPredicate;

    protected void renderChild(Ast ast, SqlBuilder builder) {
        if (this.isLowestPrecedenceUsing || !(ast instanceof ExpressionImplementor) || ((ExpressionImplementor)((Object)ast)).precedence() <= this.precedence()) {
            ast.renderTo(builder);
        } else {
            ((SqlBuilder)builder.sql("(")).space('\n');
            ast.renderTo(builder);
            ((SqlBuilder)builder.space('\n')).sql(")");
        }
    }

    protected void usingLowestPrecedence(Runnable block) {
        if (this.isLowestPrecedenceUsing) {
            block.run();
        } else {
            this.isLowestPrecedenceUsing = true;
            try {
                block.run();
            }
            finally {
                this.isLowestPrecedenceUsing = false;
            }
        }
    }

    @Override
    public final boolean hasVirtualPredicate() {
        Boolean has = this.hasVirtualPredicate;
        if (has == null) {
            this.hasVirtualPredicate = has = Boolean.valueOf(this.determineHasVirtualPredicate());
        }
        return has;
    }

    protected abstract boolean determineHasVirtualPredicate();

    @Override
    public final Ast resolveVirtualPredicate(AstContext ctx) {
        if (!this.hasVirtualPredicate()) {
            return this;
        }
        return this.onResolveVirtualPredicate(ctx);
    }

    protected abstract Ast onResolveVirtualPredicate(AstContext var1);

    protected static boolean hasVirtualPredicate(Object expression) {
        if (expression instanceof Ast && ((Ast)expression).hasVirtualPredicate()) {
            return true;
        }
        return expression instanceof MutableStatementImplementor && ((MutableStatementImplementor)expression).hasVirtualPredicate();
    }

    protected static boolean hasVirtualPredicate(Collection<?> expressions) {
        for (Object expression : expressions) {
            if (!AbstractExpression.hasVirtualPredicate(expression)) continue;
            return true;
        }
        return false;
    }

    protected static <T> boolean hasVirtualPredicate(T[] expressions) {
        for (T expression : expressions) {
            if (!AbstractExpression.hasVirtualPredicate(expression)) continue;
            return true;
        }
        return false;
    }
}

