/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.LikeMode;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.StringExpression;
import org.babyfish.jimmer.sql.ast.impl.CoalesceBuilder;
import org.babyfish.jimmer.sql.ast.impl.ComparableExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.ConcatExpression;
import org.babyfish.jimmer.sql.ast.impl.LikePredicate;
import org.babyfish.jimmer.sql.ast.impl.Literals;
import org.babyfish.jimmer.sql.ast.impl.LowerExpression;
import org.babyfish.jimmer.sql.ast.impl.ParameterUtils;
import org.babyfish.jimmer.sql.ast.impl.UpperExpression;
import org.jetbrains.annotations.NotNull;

interface StringExpressionImplementor
extends StringExpression,
ComparableExpressionImplementor<String> {
    @Override
    default public Class<String> getType() {
        return String.class;
    }

    @Override
    @NotNull
    default public Predicate like(@NotNull String pattern, @NotNull LikeMode likeMode) {
        return LikePredicate.of(this, ParameterUtils.validate("like", "pattern", pattern), false, Objects.requireNonNull(likeMode, "`likeMode` cannot be null"));
    }

    @Override
    @NotNull
    default public Predicate ilike(@NotNull String pattern, @NotNull LikeMode likeMode) {
        return LikePredicate.of(this, ParameterUtils.validate("ilike", "pattern", pattern), true, Objects.requireNonNull(likeMode, "`likeMode` cannot be null"));
    }

    @Override
    default public StringExpression upper() {
        return new UpperExpression(this);
    }

    @Override
    default public StringExpression lower() {
        return new LowerExpression(this);
    }

    @Override
    default public StringExpression concat(String ... others) {
        return this.concat((Expression[])Arrays.stream(others).filter(it -> it != null && !it.isEmpty()).map(Literals::string).toArray(StringExpression[]::new));
    }

    @Override
    @NotNull
    default public StringExpression concat(Expression<String> ... others) {
        List<Expression<String>> exprs = Arrays.stream(others).filter(Objects::nonNull).collect(Collectors.toList());
        if (exprs.isEmpty()) {
            return this;
        }
        return new ConcatExpression(this, exprs);
    }

    @Override
    @NotNull
    default public StringExpression coalesce(String defaultValue) {
        return this.coalesceBuilder().or(defaultValue).build();
    }

    @Override
    @NotNull
    default public StringExpression coalesce(Expression<String> defaultExpr) {
        return ((CoalesceBuilder.Str)this.coalesceBuilder().or((Expression)defaultExpr)).build();
    }

    @Override
    default public  @NotNull CoalesceBuilder.Str coalesceBuilder() {
        return new CoalesceBuilder.Str(this);
    }
}

