/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.associated;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.impl.AbstractMutableStatementImpl;
import org.babyfish.jimmer.sql.ast.impl.AbstractPredicate;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.ExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.PredicateWrapper;
import org.babyfish.jimmer.sql.ast.impl.associated.VirtualPredicate;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;
import org.jetbrains.annotations.NotNull;

public class VirtualPredicateMergedResult
extends AbstractPredicate {
    private static final Predicate NIL_PREDICATE = new AbstractPredicate(){

        @Override
        protected boolean determineHasVirtualPredicate() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected Ast onResolveVirtualPredicate(AstContext ctx) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void accept(@NotNull AstVisitor visitor) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void renderTo(@NotNull SqlBuilder builder) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int precedence() {
            throw new UnsupportedOperationException();
        }
    };
    private final AbstractMutableStatementImpl parent;
    private final VirtualPredicate.Op op;
    private final List<VirtualPredicate> virtualPredicates = new ArrayList<VirtualPredicate>();
    private Predicate finalPredicate;

    public VirtualPredicateMergedResult(AbstractMutableStatementImpl parent, VirtualPredicate.Op op) {
        this.parent = parent;
        this.op = op;
    }

    public void merge(VirtualPredicate predicate) {
        if (predicate != null) {
            this.virtualPredicates.add(predicate);
        }
    }

    @Override
    public void accept(@NotNull AstVisitor visitor) {
        Ast ast = (Ast)((Object)this.predicate());
        if (ast != null) {
            ast.accept(visitor);
        }
    }

    @Override
    public void renderTo(@NotNull SqlBuilder builder) {
        Ast ast = (Ast)((Object)this.predicate());
        if (ast != null) {
            ast.renderTo(builder);
        } else {
            builder.sql("1 = 1");
        }
    }

    @Override
    public int precedence() {
        return ((ExpressionImplementor)((Object)this.predicate())).precedence();
    }

    private Predicate predicate() {
        Predicate predicate = this.finalPredicate;
        if (predicate == null) {
            predicate = this.virtualPredicates.get(0).toFinalPredicate(this.parent, this.virtualPredicates, this.op);
            if (predicate == null) {
                predicate = NIL_PREDICATE;
            }
            this.finalPredicate = predicate;
        }
        return predicate == NIL_PREDICATE ? null : predicate;
    }

    @Override
    protected boolean determineHasVirtualPredicate() {
        return VirtualPredicateMergedResult.hasVirtualPredicate(this.predicate());
    }

    @Override
    protected Ast onResolveVirtualPredicate(AstContext ctx) {
        return (Ast)((Object)ctx.resolveVirtualPredicate(this.predicate()));
    }

    public static void removeEmptyResult(List<?> expressions) {
        Iterator<?> itr = expressions.iterator();
        while (itr.hasNext()) {
            Object expression = itr.next();
            if (expression instanceof PredicateWrapper) {
                PredicateWrapper wrapper = (PredicateWrapper)expression;
                expression = wrapper.unwrap();
            }
            if (!(expression instanceof VirtualPredicateMergedResult) || ((VirtualPredicateMergedResult)expression).predicate() != null) continue;
            itr.remove();
        }
    }
}

