/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Consumer;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.runtime.Internal;
import org.babyfish.jimmer.sql.ast.impl.mutation.AbstractEntitySaveCommandImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.Saver;
import org.babyfish.jimmer.sql.ast.impl.mutation.SaverCache;
import org.babyfish.jimmer.sql.ast.mutation.AbstractEntitySaveCommand;
import org.babyfish.jimmer.sql.ast.mutation.AffectedTable;
import org.babyfish.jimmer.sql.ast.mutation.BatchEntitySaveCommand;
import org.babyfish.jimmer.sql.ast.mutation.BatchSaveResult;
import org.babyfish.jimmer.sql.ast.mutation.SimpleSaveResult;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;

public class BatchEntitySaveCommandImpl<E>
extends AbstractEntitySaveCommandImpl
implements BatchEntitySaveCommand<E> {
    private final Collection<E> entities;
    private final ImmutableType type;

    public BatchEntitySaveCommandImpl(JSqlClientImplementor sqlClient, Connection con, Collection<E> entities) {
        super(sqlClient, con, null);
        ImmutableType type = null;
        for (E entity : entities) {
            if (!(entity instanceof ImmutableSpi)) {
                throw new IllegalArgumentException("All the elements of entities must be an immutable object");
            }
            if (entity instanceof DraftSpi) {
                throw new IllegalArgumentException("Each element of entity cannot be a draft object");
            }
            ImmutableType entityType = ((ImmutableSpi)entity).__type();
            if (type != null && entityType != type) {
                throw new IllegalArgumentException("All the elements of entities must belong to same immutable type");
            }
            type = entityType;
        }
        this.entities = entities;
        this.type = type;
    }

    private BatchEntitySaveCommandImpl(BatchEntitySaveCommandImpl<E> base, AbstractEntitySaveCommandImpl.Data data) {
        super(base.sqlClient, base.con, data);
        this.entities = base.entities;
        this.type = base.type;
    }

    @Override
    public BatchEntitySaveCommand<E> configure(Consumer<AbstractEntitySaveCommand.Cfg> block) {
        return (BatchEntitySaveCommand)super.configure(block);
    }

    @Override
    public BatchSaveResult<E> execute(Connection con) {
        return this.sqlClient.getConnectionManager().execute(con == null ? this.con : con, this::executeImpl);
    }

    private BatchSaveResult<E> executeImpl(Connection con) {
        this.data.freeze();
        if (this.entities.isEmpty()) {
            return new BatchSaveResult(Collections.emptyList());
        }
        SaverCache cache = new SaverCache(this.data);
        LinkedHashMap<AffectedTable, Integer> affectedRowCountMap = new LinkedHashMap<AffectedTable, Integer>();
        int size = this.entities.size();
        ArrayList oldSimpleResults = new ArrayList(size);
        Saver saver = new Saver(this.data, con, this.type, cache, false, affectedRowCountMap);
        List modifiedEntities = Internal.produceList((ImmutableType)((ImmutableSpi)this.entities.iterator().next()).__type(), this.entities, list -> {
            for (Object o : list) {
                oldSimpleResults.add(saver.save(o));
            }
        });
        saver.submitTrigger();
        ArrayList<SimpleSaveResult<SimpleSaveResult<E>>> newSimpleResults = new ArrayList<SimpleSaveResult<SimpleSaveResult<E>>>(size);
        int index = 0;
        for (E entity : this.entities) {
            SimpleSaveResult oldResult = (SimpleSaveResult)oldSimpleResults.get(index);
            newSimpleResults.add(new SimpleSaveResult<E>(oldResult.getAffectedRowCountMap(), entity, modifiedEntities.get(index)));
            ++index;
        }
        return new BatchSaveResult(affectedRowCountMap, newSimpleResults);
    }

    @Override
    BatchEntitySaveCommand<E> create(AbstractEntitySaveCommandImpl.Data data) {
        return new BatchEntitySaveCommandImpl<E>(this, data);
    }
}

