/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import org.babyfish.jimmer.meta.EmbeddedLevel;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.runtime.ImmutableSpi;

public class EmbeddableObjects {
    public static boolean isCompleted(Object embedded) {
        if (!(embedded instanceof ImmutableSpi)) {
            throw new IllegalArgumentException("The argument must be embeddable type");
        }
        return EmbeddableObjects.isCompleted((ImmutableSpi)embedded);
    }

    private static boolean isCompleted(ImmutableSpi spi) {
        ImmutableType type = spi.__type();
        if (type.isEntity()) {
            return EmbeddableObjects.isCompleted(spi, type.getIdProp());
        }
        for (ImmutableProp prop : type.getProps().values()) {
            if (EmbeddableObjects.isCompleted(spi, prop)) continue;
            return false;
        }
        return true;
    }

    private static boolean isCompleted(ImmutableSpi spi, ImmutableProp prop) {
        ImmutableSpi childSpi;
        PropId propId = prop.getId();
        if (!spi.__isLoaded(propId)) {
            return false;
        }
        return !prop.isEmbedded(EmbeddedLevel.SCALAR) || (childSpi = (ImmutableSpi)spi.__get(propId)) == null || EmbeddableObjects.isCompleted(childSpi);
    }
}

