/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.babyfish.jimmer.meta.EmbeddedLevel;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.ast.PropExpression;
import org.babyfish.jimmer.sql.ast.impl.mutation.ChainedMutationItemImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.SingleMutationImpl;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.meta.MetadataStrategy;

public interface MutationItem {
    public ImmutableProp getProp();

    public List<ImmutableProp> getProps();

    public Object getValue();

    public String columnName(MetadataStrategy var1);

    public PropExpression<Object> expression(Table<?> var1);

    public static List<MutationItem> create(final ImmutableProp prop, Object value) {
        if (prop.isReference(TargetLevel.ENTITY)) {
            PropId idPropId;
            ImmutableSpi spi;
            ImmutableProp targetIdProp = prop.getTargetType().getIdProp();
            if (value instanceof ImmutableSpi && ((ImmutableSpi)value).__type().isEntity() && (spi = (ImmutableSpi)value).__isLoaded(idPropId = targetIdProp.getId())) {
                value = spi.__get(idPropId);
            }
            if (targetIdProp.isEmbedded(EmbeddedLevel.SCALAR)) {
                return ChainedMutationItemImpl.expand(prop, targetIdProp.getTargetType(), value);
            }
            return Collections.singletonList(new ChainedMutationItemImpl(Arrays.asList(prop, targetIdProp), value, 0){

                @Override
                public PropExpression<Object> expression(Table<?> table) {
                    return table.getAssociatedId(prop);
                }
            });
        }
        if (prop.isEmbedded(EmbeddedLevel.SCALAR)) {
            return ChainedMutationItemImpl.expand(prop, prop.getTargetType(), value);
        }
        return Collections.singletonList(new SingleMutationImpl(prop, value));
    }
}

