/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation.save;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.ast.impl.mutation.save.IdPairs;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.jetbrains.annotations.NotNull;

public class EntityIdPairsImpl
implements IdPairs {
    private final Collection<ImmutableSpi> rows;
    private final PropId propId;
    private final PropId sourceIdPropId;
    private final PropId targetIdProId;
    private final boolean isList;
    private List<Tuple2<Object, Object>> tuples;
    private List<Tuple2<Object, Collection<Object>>> entries;

    public EntityIdPairsImpl(Collection<ImmutableSpi> rows, ImmutableProp prop) {
        if (!prop.isAssociation(TargetLevel.ENTITY)) {
            throw new IllegalArgumentException("The property \"" + prop + "\" is not entity association property");
        }
        this.rows = rows;
        this.propId = prop.getId();
        this.sourceIdPropId = prop.getDeclaringType().getIdProp().getId();
        this.targetIdProId = prop.getTargetType().getIdProp().getId();
        this.isList = prop.isReferenceList(TargetLevel.ENTITY);
    }

    @Override
    public Collection<Tuple2<Object, Object>> tuples() {
        List<Tuple2<Object, Object>> tuples = this.tuples;
        if (tuples == null) {
            tuples = new ArrayList<Tuple2<Object, Object>>();
            for (ImmutableSpi row : this.rows) {
                Object sourceId = row.__get(this.sourceIdPropId);
                Object associatedValue = row.__get(this.propId);
                if (this.isList) {
                    for (ImmutableSpi e : (Collection)associatedValue) {
                        Object targetId = e.__get(this.targetIdProId);
                        tuples.add(new Tuple2<Object, Object>(sourceId, targetId));
                    }
                    continue;
                }
                if (associatedValue == null) continue;
                Object targetId = ((ImmutableSpi)associatedValue).__get(this.targetIdProId);
                tuples.add(new Tuple2<Object, Object>(sourceId, targetId));
            }
            this.tuples = tuples = Collections.unmodifiableList(tuples);
        }
        return tuples;
    }

    @Override
    public Collection<Tuple2<Object, Collection<Object>>> entries() {
        List<Tuple2<Object, Collection<Object>>> entries = this.entries;
        if (entries == null) {
            entries = new ArrayList<Tuple2<Object, Collection<Object>>>(this.rows.size());
            for (ImmutableSpi row : this.rows) {
                List list;
                Object sourceId = row.__get(this.sourceIdPropId);
                Object value = row.__get(this.propId);
                Collection<Object> targetIds = value == null ? Collections.emptyList() : (this.isList ? ((list = (List)value).isEmpty() ? Collections.emptyList() : (list.size() == 1 ? Collections.singletonList(((ImmutableSpi)list.get(0)).__get(this.targetIdProId)) : new MultipleTargetIdCollection(list, this.targetIdProId))) : Collections.singletonList(((ImmutableSpi)value).__get(this.targetIdProId)));
                entries.add(new Tuple2(sourceId, targetIds));
            }
            this.entries = entries = Collections.unmodifiableList(entries);
        }
        return entries;
    }

    @Override
    public boolean isEmpty() {
        return this.rows.isEmpty();
    }

    public String toString() {
        return "EntityIdPairs" + this.entries();
    }

    private static class MultipleTargetIdCollection
    extends AbstractCollection<Object> {
        private final List<ImmutableSpi> associatedRows;
        private final PropId targetIdPropId;

        private MultipleTargetIdCollection(List<ImmutableSpi> associatedRows, PropId targetIdPropId) {
            this.associatedRows = associatedRows;
            this.targetIdPropId = targetIdPropId;
        }

        @Override
        public int size() {
            return this.associatedRows.size();
        }

        @Override
        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(@NotNull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(@NotNull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(@NotNull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Iterator<Object> iterator() {
            return new Itr();
        }

        private class Itr
        implements Iterator<Object> {
            private final Iterator<ImmutableSpi> baseItr;

            Itr() {
                this.baseItr = MultipleTargetIdCollection.this.associatedRows.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.baseItr.hasNext();
            }

            @Override
            public Object next() {
                return this.baseItr.next().__get(MultipleTargetIdCollection.this.targetIdPropId);
            }
        }
    }
}

