/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation.save;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.ast.impl.value.PropertyGetter;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;

class Shape {
    private final ImmutableType type;
    private final List<PropertyGetter> getters;
    private final int hash;
    private Map<ImmutableProp, List<PropertyGetter>> getterMap;
    private Set<PropertyGetter> getterSet;

    private Shape(ImmutableType type, List<PropertyGetter> getters) {
        this.type = type;
        this.getters = getters;
        this.hash = getters.hashCode();
    }

    public static Shape of(JSqlClientImplementor sqlClient, ImmutableSpi spi) {
        return new Shape(spi.__type(), PropertyGetter.entityGetters(sqlClient, spi.__type(), spi, true));
    }

    public static Shape fullOf(JSqlClientImplementor sqlClient, Class<?> type) {
        ImmutableType immutableType = ImmutableType.get(type);
        return new Shape(immutableType, PropertyGetter.entityGetters(sqlClient, immutableType, null, true));
    }

    public ImmutableType getType() {
        return this.type;
    }

    public List<PropertyGetter> getGetters() {
        return this.getters;
    }

    public Map<ImmutableProp, List<PropertyGetter>> getGetterMap() {
        Map<ImmutableProp, List<PropertyGetter>> getterMap = this.getterMap;
        if (getterMap == null) {
            getterMap = new TreeMap<ImmutableProp, List<PropertyGetter>>(Comparator.comparing(ImmutableProp::getName));
            for (PropertyGetter propertyGetter : this.getters) {
                getterMap.computeIfAbsent(propertyGetter.prop(), it -> new ArrayList()).add(propertyGetter);
            }
            for (Map.Entry entry : getterMap.entrySet()) {
                entry.setValue(Collections.unmodifiableList((List)entry.getValue()));
            }
            this.getterMap = getterMap = Collections.unmodifiableMap(getterMap);
        }
        return getterMap;
    }

    public List<PropertyGetter> getIdGetters() {
        return this.propertyGetters(this.type.getIdProp());
    }

    public PropertyGetter getVersionGetter() {
        List<PropertyGetter> items = this.propertyGetters(this.type.getVersionProp());
        return items.isEmpty() ? null : items.get(0);
    }

    public List<PropertyGetter> propertyGetters(ImmutableProp prop) {
        List<PropertyGetter> items = prop == null ? null : this.getGetterMap().get(prop);
        if (items == null) {
            return Collections.emptyList();
        }
        return items;
    }

    public boolean contains(PropertyGetter getter) {
        Set<PropertyGetter> set = this.getterSet;
        if (set == null) {
            this.getterSet = set = new HashSet<PropertyGetter>(this.getters);
        }
        return set.contains(getter);
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Shape)) {
            return false;
        }
        Shape other = (Shape)obj;
        return this.hash == other.hash && this.getters.equals(other.getters);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        boolean addComma = false;
        for (PropertyGetter getter : this.getters) {
            if (addComma) {
                builder.append(", ");
            } else {
                addComma = true;
            }
            builder.append(getter);
        }
        builder.append(']');
        return builder.toString();
    }
}

