/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation.save;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.BiFunction;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.ast.impl.AbstractExpression;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.TupleExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.TupleImplementor;
import org.babyfish.jimmer.sql.ast.impl.render.AbstractSqlBuilder;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.ast.tuple.Tuple3;
import org.babyfish.jimmer.sql.ast.tuple.Tuple4;
import org.babyfish.jimmer.sql.ast.tuple.Tuple5;
import org.babyfish.jimmer.sql.ast.tuple.Tuple6;
import org.babyfish.jimmer.sql.ast.tuple.Tuple7;
import org.babyfish.jimmer.sql.ast.tuple.Tuple8;
import org.babyfish.jimmer.sql.ast.tuple.Tuple9;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;
import org.jetbrains.annotations.NotNull;

class Tuples {
    Tuples() {
    }

    public static TupleImplementor valueOf(Object[] arr) {
        switch (arr.length) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("The `arr.length` must be greater than or equal to 2");
            }
            case 2: {
                return new Tuple2<Object, Object>(arr[0], arr[1]);
            }
            case 3: {
                return new Tuple3<Object, Object, Object>(arr[0], arr[1], arr[2]);
            }
            case 4: {
                return new Tuple4<Object, Object, Object, Object>(arr[0], arr[1], arr[2], arr[3]);
            }
            case 5: {
                return new Tuple5<Object, Object, Object, Object, Object>(arr[0], arr[1], arr[2], arr[3], arr[4]);
            }
            case 6: {
                return new Tuple6<Object, Object, Object, Object, Object, Object>(arr[0], arr[1], arr[2], arr[3], arr[4], arr[5]);
            }
            case 7: {
                return new Tuple7<Object, Object, Object, Object, Object, Object, Object>(arr[0], arr[1], arr[2], arr[3], arr[4], arr[5], arr[6]);
            }
            case 8: {
                return new Tuple8<Object, Object, Object, Object, Object, Object, Object, Object>(arr[0], arr[1], arr[2], arr[3], arr[4], arr[5], arr[6], arr[7]);
            }
            case 9: {
                return new Tuple9<Object, Object, Object, Object, Object, Object, Object, Object, Object>(arr[0], arr[1], arr[2], arr[3], arr[4], arr[5], arr[6], arr[7], arr[8]);
            }
        }
        return new LongTuple(arr);
    }

    public static Expression<Object> expressionOf(Expression<?>[] arr) {
        switch (arr.length) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("The `arr.length` must be greater than or equal to 2");
            }
            case 2: {
                return Expression.tuple(arr[0], arr[1]);
            }
            case 3: {
                return Expression.tuple(arr[0], arr[1], arr[2]);
            }
            case 4: {
                return Expression.tuple(arr[0], arr[1], arr[2], arr[3]);
            }
            case 5: {
                return Expression.tuple(arr[0], arr[1], arr[2], arr[3], arr[4]);
            }
            case 6: {
                return Expression.tuple(arr[0], arr[1], arr[2], arr[3], arr[4], arr[5]);
            }
            case 7: {
                return Expression.tuple(arr[0], arr[1], arr[2], arr[3], arr[4], arr[5], arr[6]);
            }
            case 8: {
                return Expression.tuple(arr[0], arr[1], arr[2], arr[3], arr[4], arr[5], arr[6], arr[7]);
            }
            case 9: {
                return Expression.tuple(arr[0], arr[1], arr[2], arr[3], arr[4], arr[5], arr[6], arr[7], arr[8]);
            }
        }
        return new LongTupleExpression(arr);
    }

    private static class LongTuple
    implements TupleImplementor {
        private final Object[] arr;

        private LongTuple(Object[] arr) {
            this.arr = arr;
        }

        @Override
        public int size() {
            return this.arr.length;
        }

        @Override
        public Object get(int index) {
            return this.arr[index];
        }

        @Override
        public TupleImplementor convert(BiFunction<Object, Integer, Object> block) {
            Object[] newArr = null;
            for (int i = this.arr.length - 1; i >= 0; --i) {
                Object oldValue = this.arr[i];
                Object newValue = block.apply(oldValue, i);
                if (Objects.equals(oldValue, newValue)) continue;
                if (newArr == null) {
                    newArr = (Object[])this.arr.clone();
                }
                newArr[i] = newValue;
            }
            if (newArr == null) {
                return this;
            }
            return new LongTuple(newArr);
        }

        public int hashCode() {
            return Arrays.hashCode(this.arr);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof LongTuple)) {
                return false;
            }
            LongTuple other = (LongTuple)obj;
            return Arrays.equals(this.arr, other.arr);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            int size = this.arr.length;
            builder.append("Tuple").append(size).append('(');
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    builder.append(", ");
                }
                builder.append('_').append(i + 1).append('=').append(this.arr[i]);
            }
            builder.append(')');
            return builder.toString();
        }
    }

    private static class LongTupleExpression
    extends AbstractExpression<TupleImplementor>
    implements TupleExpressionImplementor<TupleImplementor> {
        private final Expression<?>[] arr;

        public LongTupleExpression(Expression<?>[] arr) {
            this.arr = arr;
        }

        @Override
        protected boolean determineHasVirtualPredicate() {
            for (Expression<?> selection : this.arr) {
                if (!LongTupleExpression.hasVirtualPredicate(selection)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected Ast onResolveVirtualPredicate(AstContext ctx) {
            Expression[] newArr = null;
            int size = this.arr.length;
            for (int i = size - 1; i >= 0; --i) {
                Expression<?> oldExpr = this.arr[i];
                Expression<?> newExpr = ctx.resolveVirtualPredicate(oldExpr);
                if (oldExpr == newExpr) continue;
                if (newArr == null) {
                    newArr = (Expression[])this.arr.clone();
                }
                newArr[i] = newExpr;
            }
            if (newArr == null) {
                return this;
            }
            return new LongTupleExpression(newArr);
        }

        @Override
        public void accept(@NotNull AstVisitor visitor) {
            for (Expression<?> selection : this.arr) {
                ((Ast)((Object)selection)).accept(visitor);
            }
        }

        @Override
        public void renderTo(@NotNull SqlBuilder builder) {
            this.renderTo(builder, false);
        }

        @Override
        public void renderTo(@NotNull SqlBuilder builder, boolean ignoreBrackets) {
            if (!ignoreBrackets) {
                builder.enter(AbstractSqlBuilder.ScopeType.TUPLE);
            }
            boolean addComma = false;
            for (Expression<?> selection : this.arr) {
                if (addComma) {
                    builder.sql(", ");
                } else {
                    addComma = true;
                }
                this.renderChild((Ast)((Object)selection), builder);
            }
            if (!ignoreBrackets) {
                builder.leave();
            }
        }

        @Override
        public Class<TupleImplementor> getType() {
            return TupleImplementor.class;
        }

        @Override
        public int precedence() {
            return 0;
        }

        @Override
        public int size() {
            return this.arr.length;
        }

        @Override
        public Selection<?> get(int index) {
            return this.arr[index];
        }
    }
}

