/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation.save;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.ast.impl.mutation.save.AbstractPreHandler;
import org.babyfish.jimmer.sql.ast.impl.mutation.save.Keys;
import org.babyfish.jimmer.sql.ast.impl.mutation.save.SaveContext;
import org.babyfish.jimmer.sql.ast.impl.mutation.save.ShapedEntityMap;
import org.babyfish.jimmer.sql.meta.IdGenerator;
import org.babyfish.jimmer.sql.meta.UserIdGenerator;

class UpsertPreHandler
extends AbstractPreHandler {
    private ShapedEntityMap<DraftSpi> insertedMap;
    private ShapedEntityMap<DraftSpi> updatedMap;
    private ShapedEntityMap<DraftSpi> mergedMap;

    UpsertPreHandler(SaveContext ctx) {
        super(ctx);
    }

    @Override
    public ShapedEntityMap<DraftSpi> insertedMap() {
        this.resolve();
        return this.insertedMap;
    }

    @Override
    public ShapedEntityMap<DraftSpi> updatedMap() {
        this.resolve();
        return this.updatedMap;
    }

    @Override
    public ShapedEntityMap<DraftSpi> mergedMap() {
        this.resolve();
        return this.mergedMap;
    }

    @Override
    void onResolve() {
        DraftSpi draft2;
        Iterator itr;
        PropId idPropId = this.ctx.path.getType().getIdProp().getId();
        ArrayList<Object> insertedList = null;
        ArrayList<Object> updatedList = null;
        if (!this.draftsWithId.isEmpty() && this.isQueryRequiredForUpdate(true, this.draftsWithId)) {
            insertedList = new ArrayList<DraftSpi>();
            updatedList = new ArrayList<DraftSpi>();
            Map<Object, ImmutableSpi> idMap = this.findOldMapByIds();
            itr = this.draftsWithId.iterator();
            while (itr.hasNext()) {
                draft2 = (DraftSpi)itr.next();
                ImmutableSpi original = idMap.get(draft2.__get(idPropId));
                if (original != null) {
                    updatedList.add(draft2);
                } else {
                    insertedList.add(draft2);
                    itr.remove();
                }
                this.callInterceptor(draft2, original);
            }
        }
        if (!this.draftsWithKey.isEmpty() && this.isQueryRequiredForUpdate(false, this.draftsWithKey)) {
            if (insertedList == null) {
                insertedList = new ArrayList();
                updatedList = new ArrayList();
            }
            Map<Object, ImmutableSpi> keyMap = this.findOldMapByKeys();
            itr = this.draftsWithKey.iterator();
            while (itr.hasNext()) {
                draft2 = (DraftSpi)itr.next();
                Object key = Keys.keyOf((ImmutableSpi)draft2, this.keyProps);
                ImmutableSpi original = keyMap.get(key);
                if (original != null) {
                    updatedList.add(draft2);
                    draft2.__set(idPropId, original.__get(idPropId));
                } else {
                    insertedList.add(draft2);
                    itr.remove();
                }
                this.callInterceptor(draft2, original);
            }
        }
        if (insertedList == null) {
            this.insertedMap = ShapedEntityMap.empty();
            this.updatedMap = ShapedEntityMap.empty();
            IdGenerator idGenerator = this.ctx.options.getSqlClient().getIdGenerator(this.ctx.path.getType().getJavaClass());
            if (idGenerator instanceof UserIdGenerator) {
                for (DraftSpi draft2 : this.draftsWithKey) {
                    Object id = this.ctx.allocateId();
                    if (id == null) continue;
                    draft2.__set(idPropId, id);
                }
            }
            this.mergedMap = this.createEntityMap(this.draftsWithId, this.draftsWithKey);
        } else {
            this.insertedMap = this.createEntityMap(insertedList, null);
            this.updatedMap = this.createEntityMap(updatedList, null);
            this.mergedMap = ShapedEntityMap.empty();
        }
    }
}

