/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.query;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.ExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.query.TypedQueryImplementor;
import org.babyfish.jimmer.sql.ast.impl.query.TypedRootQueryImplementor;
import org.babyfish.jimmer.sql.ast.impl.query.UseTableVisitor;
import org.babyfish.jimmer.sql.ast.impl.table.TableTypeProvider;
import org.babyfish.jimmer.sql.ast.query.TypedRootQuery;
import org.babyfish.jimmer.sql.ast.tuple.Tuple3;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherSelection;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.Selectors;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;
import org.jetbrains.annotations.NotNull;

public class MergedTypedRootQueryImpl<R>
implements TypedRootQueryImplementor<R>,
TypedQueryImplementor {
    private final JSqlClientImplementor sqlClient;
    private final String operator;
    private final List<Selection<?>> selections;
    private final boolean isForUpdate;
    private TypedRootQueryImplementor<?>[] queries;

    @SafeVarargs
    public MergedTypedRootQueryImpl(JSqlClientImplementor sqlClient, String operator, TypedRootQuery<R> ... queries) {
        this.sqlClient = sqlClient;
        this.operator = operator;
        if (queries.length < 2) {
            throw new IllegalArgumentException("`queries.length` must not be less than 2");
        }
        TypedRootQueryImplementor[] queryArr = new TypedRootQueryImplementor[queries.length];
        queryArr[0] = (TypedRootQueryImplementor)queries[0];
        List<Selection<?>> selectionArr = null;
        boolean isForUpdate = queryArr[0].isForUpdate();
        for (int i = 1; i < queryArr.length; ++i) {
            queryArr[i] = (TypedRootQueryImplementor)queries[i];
            selectionArr = MergedTypedRootQueryImpl.mergedSelections(queryArr[0].getSelections(), queryArr[i].getSelections());
            isForUpdate |= queryArr[i].isForUpdate();
        }
        this.queries = queryArr;
        this.selections = selectionArr;
        this.isForUpdate = isForUpdate;
    }

    private static List<Selection<?>> mergedSelections(List<Selection<?>> list1, List<Selection<?>> list2) {
        if (list1.size() != list2.size()) {
            throw new IllegalArgumentException("Cannot merged sub queries with different selections");
        }
        int size = list1.size();
        for (int index = 0; index < size; ++index) {
            if (MergedTypedRootQueryImpl.isSameType(list1.get(index), list2.get(index))) continue;
            throw new IllegalArgumentException("Cannot merged sub queries with different selections");
        }
        return list1;
    }

    private static boolean isSameType(Selection<?> a, Selection<?> b) {
        if (a instanceof TableTypeProvider && b instanceof TableTypeProvider) {
            return ((TableTypeProvider)((Object)a)).getImmutableType() == ((TableTypeProvider)((Object)b)).getImmutableType();
        }
        if (a instanceof FetcherSelection && b instanceof FetcherSelection) {
            return ((FetcherSelection)a).getFetcher().equals(((FetcherSelection)b).getFetcher());
        }
        if (a instanceof Expression && b instanceof Expression) {
            return ((ExpressionImplementor)a).getType() == ((ExpressionImplementor)b).getType();
        }
        return false;
    }

    @Override
    public List<R> execute(Connection con) {
        return this.sqlClient.getSlaveConnectionManager(this.isForUpdate).execute(con, this::executeImpl);
    }

    private List<R> executeImpl(Connection con) {
        Tuple3<String, List<Object>, List<Integer>> sqlResult = this.preExecute(new SqlBuilder(new AstContext(this.sqlClient)));
        return Selectors.select(this.sqlClient, con, sqlResult.get_1(), sqlResult.get_2(), sqlResult.get_3(), this.selections, ExecutionPurpose.QUERY);
    }

    @Override
    public <X> List<X> map(Connection con, Function<R, X> mapper) {
        Object rows = this.execute(con);
        ArrayList<X> mapped = new ArrayList<X>(rows.size());
        Iterator iterator = rows.iterator();
        while (iterator.hasNext()) {
            Object row = iterator.next();
            mapped.add(mapper.apply(row));
        }
        return mapped;
    }

    @Override
    public void forEach(Connection con, int batchSize, Consumer<R> consumer) {
        int finalBatchSize = batchSize > 0 ? batchSize : this.sqlClient.getDefaultBatchSize();
        this.sqlClient.getSlaveConnectionManager(this.isForUpdate).execute(con, newConn -> {
            this.forEachImpl((Connection)newConn, finalBatchSize, consumer);
            return null;
        });
    }

    private void forEachImpl(Connection con, int batchSize, Consumer<R> consumer) {
        Tuple3<String, List<Object>, List<Integer>> sqlResult = this.preExecute(new SqlBuilder(new AstContext(this.sqlClient)));
        Selectors.forEach(this.sqlClient, con, sqlResult.get_1(), sqlResult.get_2(), sqlResult.get_3(), this.selections, ExecutionPurpose.QUERY, batchSize, consumer);
    }

    private Tuple3<String, List<Object>, List<Integer>> preExecute(SqlBuilder builder) {
        UseTableVisitor visitor = new UseTableVisitor(builder.getAstContext());
        this.accept(visitor);
        this.renderTo(builder);
        return builder.build();
    }

    @Override
    public void accept(@NotNull AstVisitor visitor) {
        for (TypedRootQueryImplementor<?> query : this.queries) {
            query.accept(visitor);
            query.accept(visitor);
        }
    }

    @Override
    public void renderTo(@NotNull SqlBuilder builder) {
        builder.enter('?' + this.operator + '?');
        for (TypedRootQueryImplementor<?> query : this.queries) {
            builder.separator();
            builder.sql("(");
            query.renderTo(builder);
            builder.sql(")");
        }
        builder.leave();
    }

    @Override
    public boolean hasVirtualPredicate() {
        for (TypedRootQueryImplementor<?> query : this.queries) {
            if (!query.hasVirtualPredicate()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Ast resolveVirtualPredicate(AstContext ctx) {
        for (int i = 0; i < this.queries.length; ++i) {
            this.queries[i] = ctx.resolveVirtualPredicate(this.queries[i]);
        }
        return this;
    }

    @Override
    public List<Selection<?>> getSelections() {
        return this.selections;
    }

    @Override
    public TypedRootQuery<R> union(TypedRootQuery<R> other) {
        return new MergedTypedRootQueryImpl<R>(this.sqlClient, "union", this, other);
    }

    @Override
    public TypedRootQuery<R> unionAll(TypedRootQuery<R> other) {
        return new MergedTypedRootQueryImpl<R>(this.sqlClient, "union all", this, other);
    }

    @Override
    public TypedRootQuery<R> minus(TypedRootQuery<R> other) {
        return new MergedTypedRootQueryImpl<R>(this.sqlClient, "minus", this, other);
    }

    @Override
    public TypedRootQuery<R> intersect(TypedRootQuery<R> other) {
        return new MergedTypedRootQueryImpl<R>(this.sqlClient, "intersect", this, other);
    }

    @Override
    public boolean isForUpdate() {
        return false;
    }
}

