/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.query;

import java.util.List;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.ast.impl.AbstractExpression;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.ExistsPredicate;
import org.babyfish.jimmer.sql.ast.impl.ExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.SubQueryFunctionExpression;
import org.babyfish.jimmer.sql.ast.impl.query.TypedQueryImplementor;
import org.babyfish.jimmer.sql.ast.impl.render.AbstractSqlBuilder;
import org.babyfish.jimmer.sql.ast.query.TypedSubQuery;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;
import org.jetbrains.annotations.NotNull;

public class MergedTypedSubQueryImpl<R>
extends AbstractExpression<R>
implements TypedSubQuery<R>,
TypedQueryImplementor {
    private final JSqlClientImplementor sqlClient;
    private final String operator;
    private final TypedQueryImplementor left;
    private final TypedQueryImplementor right;
    private final List<Selection<?>> selections;

    public MergedTypedSubQueryImpl(JSqlClientImplementor sqlClient, String operator, TypedSubQuery<R> left, TypedSubQuery<R> right) {
        this.sqlClient = sqlClient;
        this.operator = operator;
        this.left = (TypedQueryImplementor)((Object)left);
        this.right = (TypedQueryImplementor)((Object)right);
        this.selections = MergedTypedSubQueryImpl.mergedSelections(this.left.getSelections(), this.right.getSelections());
    }

    @Override
    public void accept(@NotNull AstVisitor visitor) {
        this.left.accept(visitor);
        this.right.accept(visitor);
    }

    @Override
    public void renderTo(@NotNull SqlBuilder builder) {
        builder.enter(AbstractSqlBuilder.ScopeType.SUB_QUERY);
        this.left.renderTo(builder);
        ((SqlBuilder)((SqlBuilder)builder.space('?')).sql(this.operator)).space('?');
        this.right.renderTo(builder);
        builder.leave();
    }

    @Override
    protected boolean determineHasVirtualPredicate() {
        return MergedTypedSubQueryImpl.hasVirtualPredicate(this.left) || MergedTypedSubQueryImpl.hasVirtualPredicate(this.right);
    }

    @Override
    protected Ast onResolveVirtualPredicate(AstContext ctx) {
        ctx.resolveVirtualPredicate(this.left);
        ctx.resolveVirtualPredicate(this.right);
        return this;
    }

    @Override
    public Class<R> getType() {
        return ((ExpressionImplementor)((Object)this.left)).getType();
    }

    @Override
    public int precedence() {
        return 0;
    }

    @Override
    public List<Selection<?>> getSelections() {
        return this.selections;
    }

    @Override
    public Expression<R> all() {
        return new SubQueryFunctionExpression.All(this);
    }

    @Override
    public Expression<R> any() {
        return new SubQueryFunctionExpression.Any(this);
    }

    @Override
    public Predicate exists() {
        return ExistsPredicate.of(this, false);
    }

    @Override
    public Predicate notExists() {
        return ExistsPredicate.of(this, true);
    }

    @Override
    public TypedSubQuery<R> union(TypedSubQuery<R> other) {
        return new MergedTypedSubQueryImpl<R>(this.sqlClient, "union", this, other);
    }

    @Override
    public TypedSubQuery<R> unionAll(TypedSubQuery<R> other) {
        return new MergedTypedSubQueryImpl<R>(this.sqlClient, "union all", this, other);
    }

    @Override
    public TypedSubQuery<R> minus(TypedSubQuery<R> other) {
        return new MergedTypedSubQueryImpl<R>(this.sqlClient, "minus", this, other);
    }

    @Override
    public TypedSubQuery<R> intersect(TypedSubQuery<R> other) {
        return new MergedTypedSubQueryImpl<R>(this.sqlClient, "intersect", this, other);
    }

    private static List<Selection<?>> mergedSelections(List<Selection<?>> list1, List<Selection<?>> list2) {
        if (list1.size() != list2.size()) {
            throw new IllegalArgumentException("Cannot merged sub queries with different selections");
        }
        int size = list1.size();
        for (int index = 0; index < size; ++index) {
            if (MergedTypedSubQueryImpl.isSameType(list1.get(index), list2.get(index))) continue;
            throw new IllegalArgumentException("Cannot merged sub queries with different selections");
        }
        return list1;
    }

    private static boolean isSameType(Selection<?> a, Selection<?> b) {
        if (a instanceof Table && b instanceof Table) {
            return ((Table)a).getImmutableType() == ((Table)b).getImmutableType();
        }
        if (a instanceof Expression && b instanceof Expression) {
            return ((ExpressionImplementor)a).getType() == ((ExpressionImplementor)b).getType();
        }
        return false;
    }
}

