/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.babyfish.jimmer.sql.ast.impl.util.DmNode;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractDataManager<K, V>
extends DmNode<K, V>
implements Iterable<V> {
    private static final int CAPACITY = 16;
    private final DmNode<K, V>[] tab = new DmNode[16];

    protected V getValue(K key) {
        int h = this.hashCode(key);
        h ^= h >>> 16;
        int index = 0xF & h;
        DmNode<K, V> node = this.tab[index];
        while (node != null) {
            if (this.equals(key, node.key)) {
                return node.value;
            }
            node = node.next;
        }
        return null;
    }

    protected void putValue(K key, V value) {
        DmNode<K, V> startNode;
        int h = this.hashCode(key);
        h ^= h >>> 16;
        int index = 0xF & h;
        DmNode<K, V> node = startNode = this.tab[index];
        while (node != null) {
            if (this.equals(key, node.key)) {
                node.value = value;
                return;
            }
            node = node.next;
        }
        this.tab[index] = this.createNode(h, key, value, startNode);
    }

    public boolean isEmpty() {
        return this.after == this;
    }

    @Override
    @NotNull
    public Iterator<V> iterator() {
        return new Itr();
    }

    private DmNode<K, V> createNode(int h, K key, V value, DmNode<K, V> next) {
        DmNode<K, V> node = new DmNode<K, V>(h, key, value, next);
        node.after = this;
        node.before = this.before;
        node.before.after = node;
        node.after.before = node;
        return node;
    }

    protected int hashCode(K key) {
        return key.hashCode();
    }

    protected boolean equals(K key1, K key2) {
        return key1.equals(key2);
    }

    private class Itr
    implements Iterator<V> {
        private DmNode<K, V> node;

        private Itr() {
            this.node = AbstractDataManager.this;
        }

        @Override
        public boolean hasNext() {
            return this.node.after != AbstractDataManager.this;
        }

        @Override
        public V next() {
            DmNode after = this.node.after;
            if (after == AbstractDataManager.this) {
                throw new NoSuchElementException();
            }
            this.node = after;
            return after.value;
        }
    }
}

