/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.util;

import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class InList<E>
implements Iterable<Iterable<E>> {
    private final Collection<E> values;
    private final boolean padding;
    private final int maximum;
    private CommitterImpl<E> committer;

    public InList(Collection<E> values, boolean padding, int maximum) {
        this.values = values;
        this.padding = padding;
        this.maximum = maximum;
    }

    public Committer committer() {
        this.committer = new CommitterImpl();
        return this.committer;
    }

    @Override
    @NotNull
    public Iterator<Iterable<E>> iterator() {
        CommitterImpl<E> c = this.committer;
        if (c != null && c.owner != null) {
            throw new IllegalStateException("Iterator requires no committer or new comitter");
        }
        return new Itr(this.values.iterator(), c);
    }

    private static class CommitterImpl<E>
    implements Committer {
        int count;
        boolean frozen;
        E value;
        NestedItr owner;

        private CommitterImpl() {
        }

        @Override
        public void commit() {
            if (!this.frozen) {
                ++this.count;
                this.owner.value = this.value;
            }
        }

        void reset() {
            this.count = 0;
            this.frozen = false;
        }
    }

    private class NestedItr
    implements Iterator<E> {
        private final Iterator<E> rawItr;
        private final CommitterImpl<E> committer;
        private int visited;
        private E value;

        private NestedItr(Iterator<E> rawItr, CommitterImpl<E> committer) {
            this.rawItr = rawItr;
            this.committer = committer;
            if (committer != null) {
                committer.owner = this;
            }
        }

        @Override
        public boolean hasNext() {
            boolean has;
            int committed;
            CommitterImpl c = this.committer;
            int n = committed = c != null ? c.count : this.visited;
            if (committed >= InList.this.maximum) {
                if (c != null) {
                    c.reset();
                }
                return false;
            }
            if (this.rawItr.hasNext()) {
                return true;
            }
            if (c != null) {
                c.frozen = true;
            }
            boolean bl = has = InList.this.padding && (committed & committed - 1) != 0;
            if (!has && c != null) {
                c.reset();
            }
            return has;
        }

        @Override
        public E next() {
            CommitterImpl c = this.committer;
            ++this.visited;
            if (c != null && c.frozen) {
                ++c.count;
            }
            if (!this.rawItr.hasNext()) {
                return this.value;
            }
            if (c != null) {
                c.value = this.rawItr.next();
                return c.value;
            }
            this.value = this.rawItr.next();
            return this.value;
        }
    }

    private class Itr
    implements Iterator<Iterable<E>> {
        private final Iterator<E> rawItr;
        private final CommitterImpl<E> committer;

        private Itr(Iterator<E> rawItr, CommitterImpl<E> committer) {
            this.rawItr = rawItr;
            this.committer = committer;
        }

        @Override
        public boolean hasNext() {
            return this.rawItr.hasNext();
        }

        @Override
        public Iterable<E> next() {
            return new Iterable<E>(){

                @Override
                @NotNull
                public Iterator<E> iterator() {
                    return new NestedItr(Itr.this.rawItr, Itr.this.committer);
                }
            };
        }
    }

    public static interface Committer {
        public void commit();
    }
}

