/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.value;

import java.util.ArrayList;
import java.util.List;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.ast.impl.value.AbstractPropertyGetter;
import org.babyfish.jimmer.sql.ast.impl.value.PropertyGetter;
import org.babyfish.jimmer.sql.ast.impl.value.ValueGetter;
import org.jetbrains.annotations.Nullable;

class ReferencePropertyGetter
extends AbstractPropertyGetter {
    private final ImmutableProp targetIdProp;

    ReferencePropertyGetter(@Nullable String alias, ImmutableProp prop, ValueGetter valueGetter) {
        super(alias, prop, valueGetter);
        this.targetIdProp = prop.getTargetType().getIdProp();
    }

    @Override
    public Object get(Object value) {
        ImmutableSpi spi = (ImmutableSpi)value;
        ImmutableSpi reference = (ImmutableSpi)spi.__get(this.prop.getId());
        if (reference == null) {
            return null;
        }
        return this.valueGetter.get(reference.__get(this.targetIdProp.getId()));
    }

    @Override
    String toStringPrefix() {
        return this.prop.getName() + '.' + this.targetIdProp.getName();
    }

    static List<PropertyGetter> getters(@Nullable String alias, ImmutableProp prop, List<ValueGetter> valueGetters) {
        ArrayList<PropertyGetter> propertyGetters = new ArrayList<PropertyGetter>(valueGetters.size());
        for (ValueGetter valueGetter : valueGetters) {
            propertyGetters.add(new ReferencePropertyGetter(alias, prop, valueGetter));
        }
        return propertyGetters;
    }
}

