/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.mutation;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.babyfish.jimmer.sql.ast.mutation.AbstractMutationResult;
import org.babyfish.jimmer.sql.ast.mutation.AffectedTable;
import org.babyfish.jimmer.sql.ast.mutation.SimpleSaveResult;

public class BatchSaveResult<E>
extends AbstractMutationResult {
    private List<SimpleSaveResult<E>> simpleResults;

    public BatchSaveResult(List<SimpleSaveResult<E>> simpleResults) {
        this(BatchSaveResult.mergedAffectedRowCount(simpleResults), simpleResults);
    }

    public BatchSaveResult(Map<AffectedTable, Integer> affectedRowMap, List<SimpleSaveResult<E>> simpleResults) {
        super(affectedRowMap);
        this.simpleResults = Collections.unmodifiableList(simpleResults);
    }

    public List<SimpleSaveResult<E>> getSimpleResults() {
        return this.simpleResults;
    }

    public int hashCode() {
        return Objects.hash(this.affectedRowCountMap, this.simpleResults);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchSaveResult that = (BatchSaveResult)o;
        return this.affectedRowCountMap.equals(that.affectedRowCountMap) && this.simpleResults.equals(that.simpleResults);
    }

    public String toString() {
        return "BatchSaveResult{totalAffectedRowCount=" + this.totalAffectedRowCount + ", affectedRowCountMap=" + this.affectedRowCountMap + ", simpleResults=" + this.simpleResults + '}';
    }

    private static <E> Map<AffectedTable, Integer> mergedAffectedRowCount(List<SimpleSaveResult<E>> simpleResults) {
        if (simpleResults.isEmpty()) {
            return Collections.emptyMap();
        }
        if (simpleResults.size() == 1) {
            return simpleResults.get(0).getAffectedRowCountMap();
        }
        HashMap<AffectedTable, Integer> mergedMap = new HashMap<AffectedTable, Integer>();
        for (SimpleSaveResult<E> result : simpleResults) {
            for (Map.Entry<AffectedTable, Integer> e : result.getAffectedRowCountMap().entrySet()) {
                mergedMap.merge(e.getKey(), e.getValue(), Integer::sum);
            }
        }
        return mergedMap;
    }
}

