/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.sql.cache.CacheAbandonedCallback;

public class CompositeCacheAbandonedCallback
implements CacheAbandonedCallback {
    private static final CacheAbandonedCallback[] EMPTY_CALLBACKS = new CacheAbandonedCallback[0];
    private final CacheAbandonedCallback[] callbacks;

    CompositeCacheAbandonedCallback(Collection<CacheAbandonedCallback> callbacks) {
        this.callbacks = callbacks.toArray(EMPTY_CALLBACKS);
    }

    static CacheAbandonedCallback combine(Collection<CacheAbandonedCallback> callbacks) {
        LinkedHashSet<CacheAbandonedCallback> set = new LinkedHashSet<CacheAbandonedCallback>((callbacks.size() * 4 + 2) / 3);
        for (CacheAbandonedCallback callback : callbacks) {
            if (callback == null) continue;
            set.add(callback);
        }
        switch (set.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (CacheAbandonedCallback)set.iterator().next();
            }
        }
        return new CompositeCacheAbandonedCallback(set);
    }

    @Override
    public void abandoned(ImmutableProp prop, CacheAbandonedCallback.Reason reason) {
        for (CacheAbandonedCallback callback : this.callbacks) {
            callback.abandoned(prop, reason);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompositeCacheAbandonedCallback that = (CompositeCacheAbandonedCallback)o;
        return Arrays.equals(this.callbacks, that.callbacks);
    }

    public int hashCode() {
        return Arrays.hashCode(this.callbacks);
    }
}

