/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache.redis.quarkus;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.redis.datasource.RedisDataSource;
import io.quarkus.redis.datasource.value.GetExArgs;
import io.quarkus.redis.datasource.value.ValueCommands;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.cache.CacheTracker;
import org.babyfish.jimmer.sql.cache.spi.AbstractRemoteBinder;
import org.babyfish.jimmer.sql.cache.spi.AbstractRemoteValueBinder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisValueBinder<K, V>
extends AbstractRemoteValueBinder<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisValueBinder.class);
    private final ValueCommands<String, byte[]> operations;

    protected RedisValueBinder(@Nullable ImmutableType type, @Nullable ImmutableProp prop, @Nullable CacheTracker tracker, @Nullable ObjectMapper objectMapper, @NotNull Duration duration, int randomPercent, @NotNull RedisDataSource redisDataSource) {
        super(type, prop, tracker, objectMapper, duration, randomPercent);
        this.operations = redisDataSource.value(byte[].class);
    }

    @Override
    protected List<byte[]> read(Collection<String> keys) {
        return this.multiGet(keys, this.operations);
    }

    @Override
    protected void write(Map<String, byte[]> map) {
        this.operations.mset(map);
        for (String key : map.keySet()) {
            this.operations.getex((Object)key, new GetExArgs().px(this.nextExpireMillis()));
        }
    }

    @Override
    protected void deleteAllSerializedKeys(List<String> serializedKeys) {
        for (String key : serializedKeys) {
            this.operations.getdel((Object)key);
        }
    }

    @Override
    protected boolean matched(@Nullable Object reason) {
        return "redis".equals(reason);
    }

    private List<byte[]> multiGet(Collection<String> keys, ValueCommands<String, byte[]> operations) {
        if (keys.isEmpty()) {
            return Collections.emptyList();
        }
        Object[] array = keys.toArray(keys.toArray(new String[0]));
        Map mGet = operations.mget(array);
        return new ArrayList<byte[]>(mGet.values());
    }

    @NotNull
    public static <K, V> Builder<K, V> forObject(ImmutableType type) {
        return new Builder(type, null);
    }

    @NotNull
    public static <K, V> Builder<K, V> forProp(ImmutableProp prop) {
        return new Builder(null, prop);
    }

    public static class Builder<K, V>
    extends AbstractRemoteBinder.AbstractBuilder<K, V, Builder<K, V>> {
        private RedisDataSource redisDataSource;

        protected Builder(ImmutableType type, ImmutableProp prop) {
            super(type, prop);
        }

        public Builder<K, V> redis(RedisDataSource redisDataSource) {
            this.redisDataSource = redisDataSource;
            return this;
        }

        public RedisValueBinder<K, V> build() {
            if (null == this.redisDataSource) {
                throw new IllegalStateException("RedisDataSource has not been specified");
            }
            return new RedisValueBinder(this.type, this.prop, this.tracker, this.objectMapper, this.duration, this.randomPercent, this.redisDataSource);
        }
    }
}

