/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache.spi;

import java.util.Collection;
import org.babyfish.jimmer.impl.util.StringUtil;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.cache.chain.Binder;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBinder<K>
implements Binder<K> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractBinder.class);
    protected final ImmutableType type;
    protected final ImmutableProp prop;

    public AbstractBinder(@Nullable ImmutableType type, @Nullable ImmutableProp prop) {
        if (type == null == (prop == null)) {
            throw new IllegalArgumentException("The nullity of type and prop must be different");
        }
        if (prop == null) {
            this.type = type;
            this.prop = null;
        } else {
            this.type = null;
            this.prop = prop;
        }
    }

    @Override
    @Nullable
    public final ImmutableType type() {
        return this.type;
    }

    @Override
    @Nullable
    public final ImmutableProp prop() {
        return this.prop;
    }

    @Override
    public final void deleteAll(Collection<K> keys, Object reason) {
        if (reason == null || this.matched(reason)) {
            if (LOGGER.isInfoEnabled()) {
                this.logDeletedKeys(keys);
            }
            this.deleteAllImpl(keys);
        }
    }

    protected abstract void deleteAllImpl(Collection<K> var1);

    protected void logDeletedKeys(Collection<?> keys) {
        LOGGER.info("Cache.Delete > {}: {}", (Object)this.toString(true), keys.size() == 1 ? keys.iterator().next() : keys);
    }

    protected abstract boolean matched(@Nullable Object var1);

    public String toString() {
        return this.toString(false);
    }

    protected String toString(boolean simpleName) {
        String metadata;
        if (this.prop != null) {
            metadata = simpleName ? this.prop.getDeclaringType().getJavaClass().getSimpleName() + '.' + this.prop.getName() : this.prop.toString();
        } else if (this.type != null) {
            metadata = simpleName ? this.type.getJavaClass().getSimpleName() : this.type.toString();
        } else {
            throw new AssertionError((Object)"Internal bug");
        }
        return StringUtil.removeSuffixes((String)this.getClass().getSimpleName(), (String[])new String[]{"ValueBinder", "HashBinder", "Binder"}) + '(' + metadata + ')';
    }
}

