/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache.spi;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.cache.CacheTracker;
import org.babyfish.jimmer.sql.cache.spi.AbstractBinder;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTrackingProducerBinder<K>
extends AbstractBinder<K> {
    private final CacheTracker tracker;

    public AbstractTrackingProducerBinder(@Nullable ImmutableType type, @Nullable ImmutableProp prop, @Nullable CacheTracker tracker) {
        super(type, prop);
        this.tracker = tracker;
    }

    @Override
    public final void deleteAllImpl(Collection<K> keys) {
        Set<Object> ids;
        this.deleteAllKeys(keys);
        if (this.tracker == null) {
            return;
        }
        Set<Object> set = ids = keys instanceof Set ? (Set<Object>)keys : new LinkedHashSet<K>(keys);
        if (this.prop != null) {
            this.tracker.publisher().invalidate(new CacheTracker.InvalidateEvent(this.prop, ids));
        } else {
            assert (this.type != null);
            this.tracker.publisher().invalidate(new CacheTracker.InvalidateEvent(this.type, ids));
        }
    }

    protected abstract void deleteAllKeys(Collection<K> var1);
}

