/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.dialect;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.UUID;
import org.babyfish.jimmer.sql.dialect.DefaultDialect;
import org.babyfish.jimmer.sql.dialect.Dialect;
import org.jetbrains.annotations.Nullable;

public class H2Dialect
extends DefaultDialect {
    @Override
    public boolean isIgnoreCaseLikeSupported() {
        return true;
    }

    @Override
    public boolean isArraySupported() {
        return true;
    }

    @Override
    public String arrayTypeSuffix() {
        return " array";
    }

    @Override
    public String sqlType(Class<?> elementType) {
        if (elementType == String.class) {
            return "varchar";
        }
        if (elementType == UUID.class) {
            return "char(36)";
        }
        if (elementType == Boolean.TYPE) {
            return "boolean";
        }
        if (elementType == Byte.TYPE) {
            return "tinyint";
        }
        if (elementType == Short.TYPE) {
            return "smallint";
        }
        if (elementType == Integer.TYPE) {
            return "int";
        }
        if (elementType == Long.TYPE) {
            return "bigint";
        }
        if (elementType == Float.TYPE) {
            return "float(24)";
        }
        if (elementType == Double.TYPE) {
            return "float(53)";
        }
        if (elementType == BigDecimal.class) {
            return "decimal";
        }
        if (elementType == Date.class || elementType == LocalDate.class) {
            return "date";
        }
        if (elementType == Time.class || elementType == LocalTime.class) {
            return "time without time zone";
        }
        if (elementType == OffsetTime.class) {
            return "time";
        }
        if (elementType == java.util.Date.class || elementType == Timestamp.class) {
            return "timestamp";
        }
        if (elementType == LocalDateTime.class) {
            return "timestamp";
        }
        if (elementType == OffsetDateTime.class || elementType == ZonedDateTime.class || elementType == Instant.class) {
            return "timestamp with time zone";
        }
        return null;
    }

    @Override
    public <T> T[] getArray(ResultSet rs, int col, Class<T[]> arrayType) throws SQLException {
        return rs.getObject(col, arrayType);
    }

    @Override
    public boolean isTupleCountSupported() {
        return true;
    }

    @Override
    public String getSelectIdFromSequenceSql(String sequenceName) {
        return "select nextval('" + sequenceName + "')";
    }

    @Override
    @Nullable
    public String getJsonLiteralSuffix() {
        return "format json";
    }

    @Override
    public String transCacheOperatorTableDDL() {
        return "create table JIMMER_TRANS_CACHE_OPERATOR(ID identity not null primary key,IMMUTABLE_TYPE varchar,IMMUTABLE_PROP varchar,CACHE_KEY varchar not null,REASON varchar)";
    }

    @Override
    public boolean isUpsertSupported() {
        return true;
    }

    @Override
    public boolean isAffectCountOfInsertIgnoreWrong() {
        return true;
    }

    @Override
    public void upsert(Dialect.UpsertContext ctx) {
        ctx.sql("merge into ").appendTableName().sql("(").appendInsertedColumns().sql(") key(").appendConflictColumns().sql(") values(").appendInsertingValues().sql(")");
    }
}

