/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.dialect;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.UUID;
import org.babyfish.jimmer.sql.dialect.Dialect;
import org.babyfish.jimmer.sql.dialect.PaginationContext;
import org.jetbrains.annotations.Nullable;

public class OracleDialect
implements Dialect {
    public static final String OPTIMIZE_CORE_ROW_NUMBER_ALIAS = "optimize_rn__";

    @Override
    public void paginate(PaginationContext ctx) {
        long offset = ctx.getOffset();
        if (offset == 0L) {
            this.limit(ctx);
        } else {
            if (ctx.isIdOnly()) {
                ctx.sql("select limited__.*");
                if (ctx.isIdOnly()) {
                    ctx.sql(", rownum ").sql(OPTIMIZE_CORE_ROW_NUMBER_ALIAS);
                }
            } else {
                ctx.sql("select *");
            }
            ctx.sql(" from (");
            this.limit(ctx);
            ctx.sql(") limited__ where rn__ > ");
            ctx.variable(offset);
        }
    }

    private void limit(PaginationContext ctx) {
        long offset = ctx.getOffset();
        int limit = ctx.getLimit();
        String rnProjection = offset > 0L ? ", rownum rn__" : "";
        ctx.sql("select core__.*" + rnProjection + " from (").newLine().origin().newLine().sql(") core__ where rownum <= ").variable(offset + (long)limit);
    }

    @Override
    public String getSelectIdFromSequenceSql(String sequenceName) {
        return "select " + sequenceName + ".nextval from dual";
    }

    @Override
    @Nullable
    public String getOffsetOptimizationNumField() {
        return "ROWNUM";
    }

    @Override
    public boolean isMultiInsertionSupported() {
        return false;
    }

    @Override
    @Nullable
    public String getConstantTableName() {
        return "dual";
    }

    public String sqlType(Class<?> elementType) {
        if (elementType == String.class) {
            return "varchar2";
        }
        if (elementType == UUID.class) {
            return "char(36)";
        }
        if (elementType == Boolean.TYPE) {
            return "number";
        }
        if (elementType == Byte.TYPE) {
            return "number";
        }
        if (elementType == Short.TYPE) {
            return "number";
        }
        if (elementType == Integer.TYPE) {
            return "number";
        }
        if (elementType == Long.TYPE) {
            return "number";
        }
        if (elementType == Float.TYPE) {
            return "binary_float";
        }
        if (elementType == Double.TYPE) {
            return "binary_double";
        }
        if (elementType == BigDecimal.class) {
            return "number";
        }
        if (elementType == Date.class || elementType == LocalDate.class) {
            return "date";
        }
        if (elementType == Time.class || elementType == LocalTime.class) {
            return "timestamp with time zone";
        }
        if (elementType == OffsetTime.class) {
            return "timestamp with time zone";
        }
        if (elementType == java.util.Date.class || elementType == Timestamp.class) {
            return "timestamp";
        }
        if (elementType == LocalDateTime.class) {
            return "timestamp";
        }
        if (elementType == OffsetDateTime.class || elementType == ZonedDateTime.class) {
            return "timestamp with time zone";
        }
        return null;
    }

    @Override
    public String transCacheOperatorTableDDL() {
        return "create table JIMMER_TRANS_CACHE_OPERATOR(\n\tID number generated always as identity,\n\tIMMUTABLE_TYPE varchar2(128),\n\tIMMUTABLE_PROP varchar2(128),\n\tCACHE_KEY varchar2(64) not null,\n\tREASON varchar2(32)\n)";
    }
}

