/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.filter.impl;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.babyfish.jimmer.ImmutableObjects;
import org.babyfish.jimmer.impl.util.TypeCache;
import org.babyfish.jimmer.lang.Ref;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.meta.TypedProp;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.ast.table.Props;
import org.babyfish.jimmer.sql.ast.table.PropsFor;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.table.TableEx;
import org.babyfish.jimmer.sql.cache.CachesImpl;
import org.babyfish.jimmer.sql.cache.UsedCache;
import org.babyfish.jimmer.sql.cache.spi.PropCacheInvalidators;
import org.babyfish.jimmer.sql.di.AopProxyProvider;
import org.babyfish.jimmer.sql.event.AssociationEvent;
import org.babyfish.jimmer.sql.event.EntityEvent;
import org.babyfish.jimmer.sql.event.Triggers;
import org.babyfish.jimmer.sql.event.impl.BackRefIds;
import org.babyfish.jimmer.sql.event.impl.EvictContext;
import org.babyfish.jimmer.sql.filter.AssociationIntegrityAssuranceFilter;
import org.babyfish.jimmer.sql.filter.CacheableFilter;
import org.babyfish.jimmer.sql.filter.Filter;
import org.babyfish.jimmer.sql.filter.FilterArgs;
import org.babyfish.jimmer.sql.filter.Filters;
import org.babyfish.jimmer.sql.filter.ShardingFilter;
import org.babyfish.jimmer.sql.filter.impl.FilterWrapper;
import org.babyfish.jimmer.sql.filter.impl.LogicalDeletedFilterProvider;
import org.babyfish.jimmer.sql.runtime.ConnectionManager;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.LogicalDeletedBehavior;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilterManager
implements Filters {
    private static final ThreadLocal<LinkedList<Filter<?>>> EXECUTING_FILTERS_LOCAL = new ThreadLocal();
    private final AopProxyProvider aopProxyProvider;
    private final LogicalDeletedFilterProvider provider;
    private final Set<Filter<?>> allFilters;
    private final Set<Filter<?>> disabledFilters;
    private final Map<String, List<Filter<Props>>> filterMap;
    private final Map<String, List<CacheableFilter<Props>>> allCacheableFilterMap;
    private final TypeCache<Filter<Props>> cache = new TypeCache(this::create, true);
    private final TypeCache<Filter<Props>> shardingOnlyCache = new TypeCache(this::createShardingOnly, true);
    private final TypeCache<List<CacheableFilter<Props>>> allCacheableCache = new TypeCache(this::createAllCacheable, false);
    private JSqlClientImplementor sqlClient;

    public FilterManager(AopProxyProvider aopProxyProvider, LogicalDeletedFilterProvider provider, List<Filter<?>> filters, Collection<Filter<?>> disabledFilters) {
        this.aopProxyProvider = aopProxyProvider;
        this.provider = provider;
        this.allFilters = FilterManager.standardFilters(filters);
        this.disabledFilters = FilterManager.standardDisabledFilters(null, disabledFilters, this.allFilters);
        this.filterMap = FilterManager.filterMap(this.allFilters, this.disabledFilters);
        this.allCacheableFilterMap = FilterManager.filterMap(this.allFilters.stream().filter(it -> it instanceof CacheableFilter).collect(Collectors.toList()), Collections.emptyList());
    }

    private FilterManager(AopProxyProvider aopProxyProvider, LogicalDeletedFilterProvider provider, Set<Filter<?>> filters, Set<Filter<?>> disabledFilters, Map<String, List<Filter<Props>>> filterMap, Map<String, List<CacheableFilter<Props>>> allCacheableFilterMap) {
        this.aopProxyProvider = aopProxyProvider;
        this.provider = provider;
        this.allFilters = filters;
        this.disabledFilters = disabledFilters;
        this.filterMap = filterMap;
        this.allCacheableFilterMap = allCacheableFilterMap;
    }

    @Override
    public Filter<Props> getFilter(Class<?> type, boolean shardingOnly) {
        return this.getFilter(ImmutableType.get(type), shardingOnly);
    }

    @Override
    public Filter<Props> getFilter(ImmutableType type, boolean shardingOnly) {
        if (shardingOnly) {
            return (Filter)this.shardingOnlyCache.get(type);
        }
        return (Filter)this.cache.get(type);
    }

    @Override
    public Filter<Props> getTargetFilter(TypedProp.Association<?, ?> prop, boolean shardingOnly) {
        return this.getTargetFilter(prop.unwrap(), shardingOnly);
    }

    @Override
    public Filter<Props> getTargetFilter(ImmutableProp prop, boolean shardingOnly) {
        ImmutableType targetType = prop.getTargetType();
        if (targetType == null || targetType.isEmbeddable()) {
            throw new IllegalArgumentException("`" + prop + "` is not association property");
        }
        return this.getFilter(targetType, shardingOnly);
    }

    @Override
    public Filter<Props> getLogicalDeletedFilter(ImmutableType type) {
        Filter<Props> filter = this.provider.get(type);
        if (filter == null) {
            return null;
        }
        if (filter instanceof CacheableFilter) {
            return new ExportedCacheableFilter(type, Collections.singletonList((CacheableFilter)filter));
        }
        return new ExportedFilter(Collections.singletonList(filter));
    }

    @Override
    public Ref<SortedMap<String, Object>> getParameterMapRef(Class<?> type) {
        return this.getParameterMapRef(ImmutableType.get(type));
    }

    @Override
    public Ref<SortedMap<String, Object>> getParameterMapRef(ImmutableType type) {
        Filter<Props> filter = this.getFilter(type);
        if (filter == null) {
            return Ref.empty();
        }
        if (filter instanceof CacheableFilter) {
            return Ref.of(((CacheableFilter)filter).getParameters());
        }
        return null;
    }

    @Override
    public Ref<SortedMap<String, Object>> getTargetParameterMapRef(ImmutableProp prop) {
        Filter<Props> filter = this.getTargetFilter(prop);
        if (filter == null) {
            return Ref.empty();
        }
        if (filter instanceof CacheableFilter) {
            return Ref.of(FilterManager.standardParameterMap(((CacheableFilter)filter).getParameters()));
        }
        return null;
    }

    @Override
    public Ref<SortedMap<String, Object>> getTargetParameterMapRef(TypedProp.Association<?, ?> prop) {
        return this.getTargetParameterMapRef(prop.unwrap());
    }

    public FilterManager setBehavior(LogicalDeletedBehavior behavior) {
        LogicalDeletedFilterProvider newProvider = this.provider.toBehavior(behavior);
        if (newProvider == this.provider) {
            return this;
        }
        return new FilterManager(this.aopProxyProvider, newProvider, this.allFilters, this.disabledFilters, this.filterMap, this.allCacheableFilterMap);
    }

    public FilterManager setBehavior(ImmutableType type, LogicalDeletedBehavior behavior) {
        return new FilterManager(this.aopProxyProvider, this.provider.toBehavior(type, behavior), this.allFilters, this.disabledFilters, this.filterMap, this.allCacheableFilterMap);
    }

    public FilterManager setBehavior(Class<?> type, LogicalDeletedBehavior behavior) {
        return this.setBehavior(ImmutableType.get(type), behavior);
    }

    public FilterManager setBehavior(ImmutableProp prop, LogicalDeletedBehavior behavior) {
        return new FilterManager(this.aopProxyProvider, this.provider.toBehavior(prop, behavior), this.allFilters, this.disabledFilters, this.filterMap, this.allCacheableFilterMap);
    }

    public FilterManager setBehavior(TypedProp.Association<?, ?> prop, LogicalDeletedBehavior behavior) {
        return this.setBehavior(prop.unwrap(), behavior);
    }

    public FilterManager enable(Collection<Filter<?>> filters) {
        if (filters.isEmpty()) {
            return this;
        }
        HashSet disabledSet = new HashSet(this.disabledFilters);
        for (Filter<?> filter : filters) {
            disabledSet.remove(FilterManager.unwrap(filter));
        }
        if (disabledSet.size() == this.disabledFilters.size()) {
            return this;
        }
        return new FilterManager(this.aopProxyProvider, this.provider, this.allFilters, disabledSet, FilterManager.filterMap(this.allFilters, disabledSet), this.allCacheableFilterMap);
    }

    public FilterManager disable(Collection<Filter<?>> filters) {
        if (filters.isEmpty()) {
            return this;
        }
        Set<Filter<?>> disabledSet = FilterManager.standardDisabledFilters(this.disabledFilters, filters, this.allFilters);
        if (disabledSet.size() == this.disabledFilters.size()) {
            return this;
        }
        return new FilterManager(this.aopProxyProvider, this.provider, this.allFilters, disabledSet, FilterManager.filterMap(this.allFilters, disabledSet), this.allCacheableFilterMap);
    }

    public FilterManager enableByTypes(Collection<Class<?>> filterTypes) {
        if (filterTypes.isEmpty()) {
            return this;
        }
        ArrayList deltaSet = new ArrayList();
        for (Filter<?> filter : this.disabledFilters) {
            boolean matched = false;
            for (Class<?> expectedType : filterTypes) {
                Class<?> actualType;
                if (!expectedType.isAssignableFrom(actualType = filter instanceof FilterWrapper ? ((FilterWrapper)((Object)filter)).getFilterType() : filter.getClass())) continue;
                matched = true;
                break;
            }
            if (!matched) continue;
            deltaSet.add(filter);
        }
        return this.enable(deltaSet);
    }

    public FilterManager disableByTypes(Collection<Class<?>> filterTypes) {
        if (filterTypes.isEmpty()) {
            return this;
        }
        ArrayList deltaSet = new ArrayList();
        for (Filter<?> filter : this.allFilters) {
            boolean matched = false;
            for (Class<?> expectedType : filterTypes) {
                Class<?> actualType;
                if (!expectedType.isAssignableFrom(actualType = filter instanceof FilterWrapper ? ((FilterWrapper)((Object)filter)).getFilterType() : filter.getClass())) continue;
                matched = true;
                break;
            }
            if (!matched) continue;
            deltaSet.add(filter);
        }
        return this.disable(deltaSet);
    }

    public FilterManager disableAll() {
        return this.disable(this.allFilters);
    }

    public void initialize(JSqlClientImplementor sqlClient) {
        if (this.sqlClient != null) {
            throw new IllegalStateException("The filter manager has been initialized");
        }
        if (sqlClient.getConnectionManager() == ConnectionManager.EXTERNAL_ONLY) {
            for (Filter<?> filter : this.allFilters) {
                if (!(filter instanceof CacheableFilter)) continue;
                throw new IllegalStateException("The ConnectionManager of SqlClient must be configured when \"" + CacheableFilter.class.getName() + "\" is used");
            }
        }
        this.sqlClient = sqlClient;
        this.onInitialized();
    }

    public boolean contains(ImmutableType type) {
        for (ImmutableType t : type.getAllTypes()) {
            if (!this.filterMap.containsKey(t.toString())) continue;
            return true;
        }
        return false;
    }

    public Set<Filter<?>> getFiltersAffectNullity(ImmutableProp prop) {
        List<Filter<Props>> filters;
        if (!prop.isReference(TargetLevel.ENTITY)) {
            return Collections.emptySet();
        }
        if (prop.getDeclaringType() == prop.getTargetType()) {
            return Collections.emptySet();
        }
        if (this.provider.get(prop.getTargetType()) != null) {
            return Collections.emptySet();
        }
        LinkedHashSet resultFilters = new LinkedHashSet();
        HashSet<Filter<Props>> allowedFilters = new HashSet<Filter<Props>>();
        for (ImmutableType t : prop.getDeclaringType().getAllTypes()) {
            filters = this.filterMap.get(t.toString());
            if (filters == null) continue;
            for (Filter<Props> filter : filters) {
                if (!(filter instanceof AssociationIntegrityAssuranceFilter)) continue;
                allowedFilters.addAll(filters);
            }
        }
        for (ImmutableType t : prop.getTargetType().getAllTypes()) {
            filters = this.filterMap.get(t.toString());
            if (filters == null) continue;
            for (Filter<Props> filter : filters) {
                if (allowedFilters.contains(filter)) continue;
                resultFilters.add(filter);
            }
        }
        return resultFilters;
    }

    private Filter<Props> create(ImmutableType type) {
        return this.create(type, false);
    }

    private Filter<Props> createShardingOnly(ImmutableType type) {
        return this.create(type, true);
    }

    private Filter<Props> create(ImmutableType type, boolean shardingOnly) {
        LinkedHashSet<Filter<Props>> filters = new LinkedHashSet<Filter<Props>>();
        if (type != null) {
            Filter<Props> logicalDeletedFilter = this.provider.get(type);
            if (logicalDeletedFilter != null) {
                filters.add(logicalDeletedFilter);
            }
            for (ImmutableType t : type.getAllTypes()) {
                List<Filter<Props>> list = this.filterMap.get(t.toString());
                if (list == null) continue;
                for (Filter<Props> filter : list) {
                    if (shardingOnly && !(filter instanceof ShardingFilter) || this.disabledFilters.contains(filter)) continue;
                    filters.add(filter);
                }
            }
        }
        if (filters.isEmpty()) {
            return null;
        }
        for (Filter filter : filters) {
            if (filter instanceof CacheableFilter) continue;
            return new ExportedFilter(filters);
        }
        return new ExportedCacheableFilter(type, filters);
    }

    private List<CacheableFilter<Props>> createAllCacheable(ImmutableType type) {
        ArrayList<CacheableFilter<Props>> filters = new ArrayList<CacheableFilter<Props>>();
        for (ImmutableType t : type.getAllTypes()) {
            List<CacheableFilter<Props>> list = this.allCacheableFilterMap.get(t.toString());
            Filter<Props> logicalDeletedFilter = this.provider.get(type);
            if (logicalDeletedFilter instanceof CacheableFilter) {
                if (list == null) {
                    list = new ArrayList<CacheableFilter<Props>>();
                }
                list.add((CacheableFilter)logicalDeletedFilter);
            }
            if (list == null) continue;
            for (CacheableFilter<Props> filter : list) {
                if (this.disabledFilters.contains(filter)) continue;
                filters.add(filter);
            }
        }
        return filters;
    }

    public static ImmutableType getImmutableType(Filter<?> filter) {
        Class propsClass;
        if (filter instanceof FilterWrapper) {
            return ((FilterWrapper)((Object)filter)).getImmutableType();
        }
        Class<?> filterClass = filter.getClass();
        Collection filterTypeArguments = TypeUtils.getTypeArguments(filterClass, Filter.class).values();
        if (filterTypeArguments.isEmpty()) {
            throw new IllegalStateException("`" + filterClass.getName() + "` does not specify the type argument of `" + Filter.class.getName() + "`");
        }
        Type propsType = (Type)filterTypeArguments.iterator().next();
        if (propsType instanceof Class) {
            propsClass = (Class)propsType;
        } else if (propsType instanceof ParameterizedType) {
            propsClass = (Class)((ParameterizedType)propsType).getRawType();
        } else {
            throw new IllegalStateException("`" + filterClass.getName() + "` is illegal, the type argument of `" + Filter.class.getName() + "` can only be class of parameterized type");
        }
        if (TableEx.class.isAssignableFrom(propsClass)) {
            throw new IllegalStateException("`" + filterClass.getName() + "` is illegal, the type argument of `" + Filter.class.getName() + "` can not be `TableEx`");
        }
        if (Table.class.isAssignableFrom(propsClass)) {
            Collection propsTypeArguments = TypeUtils.getTypeArguments((Type)propsType, Table.class).values();
            if (propsTypeArguments.isEmpty()) {
                throw new IllegalStateException("`" + filterClass.getName() + "` does not specify the type argument of `" + Table.class.getName() + "`");
            }
            Type entityType = (Type)propsTypeArguments.iterator().next();
            if (!(entityType instanceof Class)) {
                throw new IllegalStateException("`" + filterClass.getName() + "` is illegal, the type argument of `" + Table.class.getName() + "` can only be class or interface");
            }
            return ImmutableType.get((Class)((Class)entityType));
        }
        if (Props.class.isAssignableFrom(propsClass)) {
            if (Props.class == propsClass) {
                throw new IllegalStateException("`" + filterClass.getName() + "` is illegal, its type argument cannot be `" + propsClass.getName() + "`");
            }
            PropsFor propsFor = propsClass.getAnnotation(PropsFor.class);
            if (propsFor == null) {
                throw new IllegalStateException("`" + filterClass.getName() + "` is illegal, the type argument of `" + Props.class.getName() + "` is `" + propsClass.getName() + "` which is not decorated by `@" + PropsFor.class.getName() + "`");
            }
            return ImmutableType.get(propsFor.value());
        }
        throw new IllegalStateException("`" + filterClass.getName() + "` is illegal, its type argument must inherit `" + Props.class.getName() + "`");
    }

    private static Set<Filter<?>> standardFilters(Collection<Filter<?>> filters) {
        LinkedHashSet set = new LinkedHashSet();
        for (Filter<?> filter : filters) {
            Filter<?> unwrapped = FilterManager.unwrap(filter);
            if (unwrapped == null || unwrapped instanceof LogicalDeletedFilterProvider.Internal) continue;
            set.add(unwrapped);
        }
        return set;
    }

    private static Filter<?> unwrap(Filter<?> filter) {
        Object o = filter;
        while (o instanceof FilterWrapper) {
            if (!((o = ((FilterWrapper)o).unwrap()) instanceof Filter)) continue;
            filter = (Filter)o;
        }
        return filter;
    }

    private static Map<String, List<Filter<Props>>> filterMap(Collection<Filter<?>> filters, Collection<Filter<?>> disabledFilters) {
        HashMap<String, List<Filter<Props>>> map = new HashMap<String, List<Filter<Props>>>();
        for (Filter<?> filter : filters) {
            if (filter == null || disabledFilters.contains(filter)) continue;
            ImmutableType immutableType = FilterManager.getImmutableType(filter);
            map.computeIfAbsent(immutableType.toString(), it -> new ArrayList()).add(filter);
        }
        return map;
    }

    private static Set<Filter<?>> standardDisabledFilters(Collection<Filter<?>> base, Collection<Filter<?>> more, Collection<Filter<?>> all) {
        HashSet set = base != null ? new HashSet(base) : new HashSet();
        for (Filter<?> filter : more) {
            Filter<?> unwrapped = FilterManager.unwrap(filter);
            if (unwrapped == null || unwrapped instanceof LogicalDeletedFilterProvider.Internal) continue;
            set.add(unwrapped);
        }
        set.retainAll(all);
        return set;
    }

    private static Collection<?> affectedSourceIds(List<CacheableFilter<Props>> filters, EntityEvent<?> e) {
        if (filters.size() == 1) {
            return filters.get(0).getAffectedSourceIds(e);
        }
        LinkedHashSet ids = null;
        for (CacheableFilter<Props> filter : filters) {
            Collection<?> someIds = filter.getAffectedSourceIds(e);
            if (someIds == null || someIds.isEmpty()) continue;
            if (ids == null) {
                ids = new LinkedHashSet();
            }
            for (Object someId : someIds) {
                if (someId == null) continue;
                ids.add(someId);
            }
        }
        return ids == null || ids.isEmpty() ? null : ids;
    }

    private static Collection<?> affectedSourceIds(List<CacheableFilter<Props>> filters, AssociationEvent e) {
        if (filters.size() == 1) {
            return filters.get(0).getAffectedSourceIds(e);
        }
        LinkedHashSet ids = null;
        for (CacheableFilter<Props> filter : filters) {
            Collection<?> someIds = filter.getAffectedSourceIds(e);
            if (someIds == null || someIds.isEmpty()) continue;
            if (ids == null) {
                ids = new LinkedHashSet();
            }
            for (Object someId : someIds) {
                if (someId == null) continue;
                ids.add(someId);
            }
        }
        return ids == null || ids.isEmpty() ? null : ids;
    }

    private void onInitialized() {
        List filters;
        for (Filter<?> filter : this.allFilters) {
            if (!(filter instanceof CacheableFilter)) continue;
            ((CacheableFilter)filter).initialize(this.sqlClient);
        }
        CachesImpl caches = (CachesImpl)this.sqlClient.getCaches();
        for (Map.Entry<ImmutableType, UsedCache<?, ?>> entry : caches.getObjectCacheMap().entrySet()) {
            ImmutableType type = entry.getKey();
            filters = (List)this.allCacheableCache.get(type);
            if (!filters.isEmpty() && PropCacheInvalidators.isGetAffectedSourceIdsOverridden(filters, EntityEvent.class, this.aopProxyProvider)) {
                this.sqlClient.getTriggers().addEntityListener(e -> EvictContext.execute(() -> this.handleOtherChange(type, (List<CacheableFilter<Props>>)filters, e)));
            }
            if (filters.isEmpty() || !PropCacheInvalidators.isGetAffectedSourceIdsOverridden(filters, AssociationEvent.class, this.aopProxyProvider)) continue;
            this.sqlClient.getTriggers().addAssociationListener(e -> EvictContext.execute(() -> this.handleOtherChange(type, (List<CacheableFilter<Props>>)filters, e)));
        }
        for (Map.Entry<ImmutableType, UsedCache<?, ?>> entry : caches.getPropCacheMap().entrySet()) {
            ImmutableProp prop = (ImmutableProp)entry.getKey();
            if (!prop.isAssociation(TargetLevel.PERSISTENT) || (filters = (List)this.allCacheableCache.get(prop.getTargetType())).isEmpty()) continue;
            this.sqlClient.getTriggers().addEntityListener(prop.getTargetType(), e -> this.handleTargetChange(prop, filters, e));
        }
    }

    private void handleTargetChange(ImmutableProp prop, List<CacheableFilter<Props>> filters, EntityEvent<?> e) {
        ImmutableProp mappedBy;
        if (e.isEvict()) {
            return;
        }
        boolean affected = false;
        for (CacheableFilter<Props> filter : filters) {
            if (!filter.isAffectedBy(e)) continue;
            affected = true;
            break;
        }
        if (!affected) {
            return;
        }
        if (prop.isAssociation(TargetLevel.PERSISTENT) && (mappedBy = prop.getMappedBy()) != null && mappedBy.isColumnDefinition()) {
            ImmutableSpi oe = (ImmutableSpi)e.getOldEntity();
            ImmutableSpi ne = (ImmutableSpi)e.getNewEntity();
            if (oe == null || ne == null) {
                return;
            }
            Ref unchangedParentRef = e.getUnchangedRef(mappedBy);
            if (unchangedParentRef == null) {
                return;
            }
            ImmutableSpi unchangedParent = (ImmutableSpi)unchangedParentRef.getValue();
            if (unchangedParent == null) {
                return;
            }
            ImmutableProp parentIdProp = mappedBy.getTargetType().getIdProp();
            Object parentId = ImmutableObjects.get((Object)unchangedParent, (ImmutableProp)parentIdProp);
            this.sqlClient.getTriggers().fireAssociationEvict(prop, parentId, e.getConnection(), e.getReason());
            return;
        }
        List<?> backRefIds = BackRefIds.findBackRefIds(this.sqlClient, prop, e.getId(), e.getConnection());
        for (Object backRefId : backRefIds) {
            this.sqlClient.getTriggers().fireAssociationEvict(prop, backRefId, e.getConnection(), e.getReason());
        }
    }

    private void handleOtherChange(ImmutableType type, List<CacheableFilter<Props>> filters, EntityEvent<?> e) {
        Collection<?> sourceIds;
        EvictContext ctx = EvictContext.get();
        if (ctx != null) {
            ctx.add(e.getImmutableType(), e.getId());
        }
        if ((sourceIds = FilterManager.affectedSourceIds(filters, e)) != null) {
            Triggers triggers = this.sqlClient.getTriggers();
            for (Object sourceId : sourceIds) {
                triggers.fireEntityEvict(type, sourceId, e.getConnection());
            }
        }
    }

    private void handleOtherChange(ImmutableType type, List<CacheableFilter<Props>> filters, AssociationEvent e) {
        Collection<?> sourceIds;
        EvictContext ctx = EvictContext.get();
        if (ctx != null) {
            ctx.add(e.getImmutableProp(), e.getSourceId());
        }
        if (ctx != null && !e.isEvict()) {
            ctx.disable(e.getImmutableProp());
        }
        if ((sourceIds = FilterManager.affectedSourceIds(filters, e)) != null) {
            Triggers triggers = this.sqlClient.getTriggers();
            for (Object sourceId : sourceIds) {
                triggers.fireEntityEvict(type, sourceId, e.getConnection());
            }
        }
    }

    public Set<ImmutableType> getAffectedTypes(Collection<ImmutableType> allTypes) {
        HashSet<ImmutableType> affectTypes = new HashSet<ImmutableType>();
        block0: for (ImmutableType type : allTypes) {
            for (ImmutableType upcastType : type.getAllTypes()) {
                if (affectTypes.contains(upcastType) || !this.filterMap.containsKey(upcastType.toString())) continue;
                affectTypes.add(type);
                continue block0;
            }
        }
        return affectTypes;
    }

    @Override
    @NotNull
    public LogicalDeletedBehavior getBehavior(ImmutableType type) {
        return this.provider.getBehavior(type);
    }

    @Override
    @NotNull
    public LogicalDeletedBehavior getBehavior(ImmutableProp prop) {
        return this.provider.getBehavior(prop);
    }

    public static Filter<?> currentFilter() {
        LinkedList<Filter<?>> executingFilters = EXECUTING_FILTERS_LOCAL.get();
        return executingFilters != null ? executingFilters.peek() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executing(Filter<?> filter, Runnable block) {
        if (filter == null) {
            block.run();
            return;
        }
        if (filter instanceof Exported) {
            throw new IllegalArgumentException("The filter cannot be exported filter");
        }
        LinkedList<Filter<Object>> executingFilters = EXECUTING_FILTERS_LOCAL.get();
        if (executingFilters == null) {
            executingFilters = new LinkedList();
            executingFilters.add(filter);
            EXECUTING_FILTERS_LOCAL.set(executingFilters);
            try {
                block.run();
            }
            finally {
                EXECUTING_FILTERS_LOCAL.remove();
            }
        }
        if (executingFilters.contains(filter)) {
            throw new IllegalStateException("A dead recursion was discovered during the filter execution process, where the filter \"" + filter + "\" to be executed is the same as the filters \"" + executingFilters + "\" currently being executed in the context.");
        }
        executingFilters.push(filter);
        try {
            block.run();
        }
        finally {
            executingFilters.pop();
        }
    }

    private static SortedMap<String, Object> standardParameterMap(SortedMap<String, Object> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            return parameters;
        }
        boolean hasNullValue = false;
        for (Object o : parameters.values()) {
            if (o != null) continue;
            hasNullValue = true;
            break;
        }
        if (!hasNullValue) {
            return parameters;
        }
        TreeMap<String, Object> withoutNullValueMap = new TreeMap<String, Object>();
        for (Map.Entry<String, Object> e : parameters.entrySet()) {
            Object value = e.getValue();
            if (value == null) continue;
            withoutNullValueMap.put(e.getKey(), value);
        }
        return withoutNullValueMap;
    }

    public static boolean hasUserFilter(Filter<?> filter) {
        if (filter == null) {
            return false;
        }
        return !(filter instanceof Exported) || !((Exported)((Object)filter)).isLogicalDeletedFilter();
    }

    private static class ExportedCacheableFilter
    implements CacheableFilter<Props>,
    Exported {
        private final ImmutableType type;
        private final List<CacheableFilter<Props>> filters;

        private ExportedCacheableFilter(ImmutableType type, Collection<CacheableFilter<Props>> filters) {
            this.type = type;
            this.filters = new ArrayList<CacheableFilter<Props>>(filters);
        }

        @Override
        public void filter(FilterArgs<Props> args) {
            for (Filter filter : this.filters) {
                FilterManager.executing(filter, () -> filter.filter(args));
            }
        }

        @Override
        public SortedMap<String, Object> getParameters() {
            TreeMap<String, Object> map = new TreeMap<String, Object>();
            for (CacheableFilter<Props> filter : this.filters) {
                SortedMap<String, Object> subMap = filter.getParameters();
                if (subMap == null || subMap.isEmpty()) continue;
                for (Map.Entry<String, Object> e : subMap.entrySet()) {
                    String key = e.getKey();
                    if (key == null || key.isEmpty()) {
                        throw new IllegalStateException("The method `getParameters` of \"" + filter.getClass().getName() + "\" cannot map with null or empty key");
                    }
                    Object value = e.getValue();
                    if (value == null) continue;
                    Object conflictValue = map.get(key);
                    if (conflictValue != null && !conflictValue.equals(value)) {
                        throw new IllegalStateException("Duplicated parameter key `" + key + "` in filters: " + this.filters);
                    }
                    map.put(key, value);
                }
            }
            return map;
        }

        @Override
        public boolean isAffectedBy(EntityEvent<?> e) {
            if (this.type.isAssignableFrom(e.getImmutableType())) {
                for (CacheableFilter<Props> filter : this.filters) {
                    if (!filter.isAffectedBy(e)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        @Nullable
        public Collection<?> getAffectedSourceIds(@NotNull EntityEvent<?> e) {
            return FilterManager.affectedSourceIds((List<CacheableFilter<Props>>)this.filters, e);
        }

        @Override
        @Nullable
        public Collection<?> getAffectedSourceIds(@NotNull AssociationEvent e) {
            return FilterManager.affectedSourceIds((List<CacheableFilter<Props>>)this.filters, e);
        }

        @Override
        public boolean isLogicalDeletedFilter() {
            return this.filters.size() == 1 && this.filters.get(0) instanceof LogicalDeletedFilterProvider.DefaultFilter;
        }

        public String toString() {
            return "ExportedCacheableFilter{filters=" + this.filters + '}';
        }
    }

    private static class ExportedFilter
    implements Filter<Props>,
    Exported {
        private final List<Filter<Props>> filters;

        private ExportedFilter(Collection<Filter<Props>> filters) {
            this.filters = new ArrayList<Filter<Props>>(filters);
        }

        @Override
        public void filter(FilterArgs<Props> args) {
            for (Filter<Props> filter : this.filters) {
                FilterManager.executing(filter, () -> filter.filter(args));
            }
        }

        @Override
        public boolean isLogicalDeletedFilter() {
            return this.filters.size() == 1 && this.filters.get(0) instanceof LogicalDeletedFilterProvider.DefaultFilter;
        }

        public String toString() {
            return "ExportedFilter{filters=" + this.filters + '}';
        }
    }

    public static interface Exported {
        public boolean isLogicalDeletedFilter();
    }
}

