/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.filter.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import org.babyfish.jimmer.impl.util.StaticCache;
import org.babyfish.jimmer.impl.util.TypeCache;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.LogicalDeletedInfo;
import org.babyfish.jimmer.sql.association.meta.AssociationType;
import org.babyfish.jimmer.sql.ast.PropExpression;
import org.babyfish.jimmer.sql.ast.table.Props;
import org.babyfish.jimmer.sql.event.EntityEvent;
import org.babyfish.jimmer.sql.filter.CacheableFilter;
import org.babyfish.jimmer.sql.filter.Filter;
import org.babyfish.jimmer.sql.filter.FilterArgs;
import org.babyfish.jimmer.sql.filter.impl.FilterWrapper;
import org.babyfish.jimmer.sql.runtime.LogicalDeletedBehavior;

public class LogicalDeletedFilterProvider {
    private final TypeCache<Filter<Props>> typeCache = new TypeCache(this::createTypeProvider, true);
    private final StaticCache<ImmutableProp, Filter<Props>> propCache = new StaticCache(this::createPropProvider, true);
    private final LogicalDeletedBehavior defaultBehavior;
    private final Map<ImmutableType, LogicalDeletedBehavior> typeBehaviorMap;
    private final Map<ImmutableProp, LogicalDeletedBehavior> propBehaviorMap;
    private final String microServiceName;

    public LogicalDeletedFilterProvider(LogicalDeletedBehavior behavior, Map<ImmutableType, LogicalDeletedBehavior> typeBehaviorMap, Map<ImmutableProp, LogicalDeletedBehavior> propBehaviorMap, String microServiceName) {
        this.defaultBehavior = behavior;
        this.typeBehaviorMap = typeBehaviorMap;
        this.propBehaviorMap = propBehaviorMap;
        this.microServiceName = microServiceName;
    }

    public Filter<Props> get(ImmutableType type) {
        return (Filter)this.typeCache.get(type);
    }

    public Filter<Props> get(ImmutableProp prop) {
        return (Filter)this.propCache.get((Object)prop);
    }

    public LogicalDeletedFilterProvider toBehavior(LogicalDeletedBehavior behavior) {
        if (this.defaultBehavior == behavior) {
            return this;
        }
        return new LogicalDeletedFilterProvider(behavior, this.typeBehaviorMap, this.propBehaviorMap, this.microServiceName);
    }

    public LogicalDeletedFilterProvider toBehavior(ImmutableType type, LogicalDeletedBehavior behavior) {
        if (type instanceof AssociationType) {
            return this.toBehavior(((AssociationType)type).getBaseProp(), behavior);
        }
        if (this.typeBehaviorMap.get(type) == behavior) {
            return this;
        }
        LogicalDeletedInfo info = type.getLogicalDeletedInfo();
        if (info == null) {
            throw new IllegalArgumentException("Cannot set the logical deleted behavior of \"" + type + "\" it does not support logical deletion");
        }
        HashMap<ImmutableType, LogicalDeletedBehavior> map = new HashMap<ImmutableType, LogicalDeletedBehavior>(this.typeBehaviorMap);
        map.put(type, behavior);
        return new LogicalDeletedFilterProvider(this.defaultBehavior, map, this.propBehaviorMap, this.microServiceName);
    }

    public LogicalDeletedFilterProvider toBehavior(ImmutableProp prop, LogicalDeletedBehavior behavior) {
        if (this.propBehaviorMap.get(prop) == behavior) {
            return this;
        }
        LogicalDeletedInfo info = prop.getMappedBy() != null ? LogicalDeletedInfo.of((ImmutableProp)prop.getMappedBy()) : LogicalDeletedInfo.of((ImmutableProp)prop);
        if (info == null) {
            throw new IllegalArgumentException("Cannot set the logical deleted behavior of \"" + prop + "\" it is based on middle table with logical deletion");
        }
        HashMap<ImmutableProp, LogicalDeletedBehavior> map = new HashMap<ImmutableProp, LogicalDeletedBehavior>(this.propBehaviorMap);
        map.put(prop, behavior);
        ImmutableProp oppositeProp = prop.getOpposite();
        if (oppositeProp != null) {
            map.put(oppositeProp, behavior);
        }
        return new LogicalDeletedFilterProvider(this.defaultBehavior, this.typeBehaviorMap, map, this.microServiceName);
    }

    public LogicalDeletedBehavior getBehavior(ImmutableType type) {
        return this.typeBehaviorMap.getOrDefault(type, this.defaultBehavior);
    }

    public LogicalDeletedBehavior getBehavior(ImmutableProp prop) {
        return this.propBehaviorMap.getOrDefault(prop, this.defaultBehavior);
    }

    private Filter<Props> createTypeProvider(ImmutableType type) {
        LogicalDeletedInfo info = type.getLogicalDeletedInfo();
        if (info == null) {
            return null;
        }
        LogicalDeletedBehavior behavior = this.typeBehaviorMap.getOrDefault(type, this.defaultBehavior);
        switch (behavior) {
            case IGNORED: {
                return new IgnoredFilter(info);
            }
            case REVERSED: {
                return new ReversedFilter(info);
            }
        }
        return new DefaultFilter(info);
    }

    private Filter<Props> createPropProvider(ImmutableProp prop) {
        LogicalDeletedInfo info = LogicalDeletedInfo.of((ImmutableProp)prop);
        if (info == null) {
            return null;
        }
        LogicalDeletedBehavior behavior = this.propBehaviorMap.getOrDefault(prop, this.defaultBehavior);
        switch (behavior) {
            case IGNORED: {
                return new IgnoredFilter(info);
            }
            case REVERSED: {
                return new ReversedFilter(info);
            }
        }
        return new DefaultFilter(info);
    }

    public static class IgnoredFilter
    implements Filter<Props>,
    FilterWrapper,
    Internal {
        protected final LogicalDeletedInfo info;

        IgnoredFilter(LogicalDeletedInfo info) {
            this.info = info;
        }

        @Override
        public Class<?> getFilterType() {
            return this.getClass();
        }

        @Override
        public ImmutableType getImmutableType() {
            return this.info.getProp().getDeclaringType();
        }

        @Override
        public void filter(FilterArgs<Props> args) {
        }
    }

    private static class ReversedFilter
    implements Filter<Props>,
    FilterWrapper,
    Internal {
        protected final LogicalDeletedInfo info;

        ReversedFilter(LogicalDeletedInfo info) {
            this.info = info;
        }

        @Override
        public Class<?> getFilterType() {
            return this.getClass();
        }

        @Override
        public ImmutableType getImmutableType() {
            return this.info.getProp().getDeclaringType();
        }

        @Override
        public void filter(FilterArgs<Props> args) {
            PropExpression expr = args.getTable().get(this.info.getProp().getName());
            LogicalDeletedInfo.Action action = this.info.getAction().reversed();
            if (action instanceof LogicalDeletedInfo.Action.Eq) {
                LogicalDeletedInfo.Action.Eq eq = (LogicalDeletedInfo.Action.Eq)action;
                args.where(expr.eq(eq.getValue()));
            } else if (action instanceof LogicalDeletedInfo.Action.Ne) {
                LogicalDeletedInfo.Action.Ne ne = (LogicalDeletedInfo.Action.Ne)action;
                args.where(expr.ne(ne.getValue()));
            } else if (action instanceof LogicalDeletedInfo.Action.IsNull) {
                args.where(expr.isNull());
            } else if (action instanceof LogicalDeletedInfo.Action.IsNotNull) {
                args.where(expr.isNotNull());
            }
        }
    }

    static class DefaultFilter
    implements CacheableFilter<Props>,
    FilterWrapper,
    Internal {
        protected final LogicalDeletedInfo info;

        DefaultFilter(LogicalDeletedInfo info) {
            this.info = info;
        }

        @Override
        public Class<?> getFilterType() {
            return this.getClass();
        }

        @Override
        public ImmutableType getImmutableType() {
            return this.info.getProp().getDeclaringType();
        }

        @Override
        public void filter(FilterArgs<Props> args) {
            PropExpression expr = args.getTable().get(this.info.getProp().getName());
            LogicalDeletedInfo.Action action = this.info.getAction();
            if (action instanceof LogicalDeletedInfo.Action.Eq) {
                LogicalDeletedInfo.Action.Eq eq = (LogicalDeletedInfo.Action.Eq)action;
                args.where(expr.eq(eq.getValue()));
            } else if (action instanceof LogicalDeletedInfo.Action.Ne) {
                LogicalDeletedInfo.Action.Ne ne = (LogicalDeletedInfo.Action.Ne)action;
                args.where(expr.ne(ne.getValue()));
            } else if (action instanceof LogicalDeletedInfo.Action.IsNull) {
                args.where(expr.isNull());
            } else if (action instanceof LogicalDeletedInfo.Action.IsNotNull) {
                args.where(expr.isNotNull());
            }
        }

        @Override
        public SortedMap<String, Object> getParameters() {
            return Collections.emptySortedMap();
        }

        @Override
        public boolean isAffectedBy(EntityEvent<?> e) {
            return e.isChanged(this.info.getProp());
        }
    }

    public static interface Internal {
    }
}

