/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.loader;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.babyfish.jimmer.sql.TransientResolver;

public class TransientResolverContext {
    private static final ThreadLocal<TransientResolverContext> CONTEXT_LOCAL = new ThreadLocal();
    private final TransientResolverContext parent;
    private final Connection con;
    private final TransientResolver<?, ?> resolver;
    private final Set<Object> sourceIds;

    private TransientResolverContext(TransientResolverContext parent, Connection con, TransientResolver<?, ?> resolver, Set<Object> sourceIds) {
        this.parent = parent;
        this.con = con;
        this.resolver = resolver;
        this.sourceIds = sourceIds;
    }

    public Connection getConnection() {
        return this.con;
    }

    public static TransientResolverContext push(Connection con, TransientResolver<?, ?> resolver, Collection<Object> sourceIds) {
        TransientResolverContext parent;
        LinkedHashSet<Object> sourceIdSet = sourceIds instanceof Set ? (LinkedHashSet<Object>)sourceIds : new LinkedHashSet<Object>(sourceIds);
        TransientResolverContext ancestor = parent = CONTEXT_LOCAL.get();
        while (ancestor != null) {
            List<Object> intersect;
            if (ancestor.resolver.equals(resolver) && (intersect = TransientResolverContext.intersect(sourceIdSet, ancestor.sourceIds)) != null) {
                throw new IllegalStateException("Discover the dead recursion of transient resolver invocations, transient resolver: " + ancestor.resolver + "sourceIds: " + intersect);
            }
            ancestor = ancestor.parent;
        }
        TransientResolverContext ctx = new TransientResolverContext(parent, con, resolver, sourceIdSet);
        CONTEXT_LOCAL.set(ctx);
        return ctx;
    }

    public static void pop(TransientResolverContext ctx) {
        CONTEXT_LOCAL.set(ctx.parent);
    }

    public static TransientResolverContext peek() {
        return CONTEXT_LOCAL.get();
    }

    private static List<Object> intersect(Set<Object> a, Set<Object> b) {
        if (a.size() > b.size()) {
            return TransientResolverContext.intersect(b, a);
        }
        ArrayList<Object> intersect = null;
        for (Object e : a) {
            if (!b.contains(e)) continue;
            if (intersect == null) {
                intersect = new ArrayList<Object>();
            }
            intersect.add(e);
        }
        return intersect;
    }
}

