/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import java.sql.Connection;
import java.util.Objects;
import java.util.function.Function;
import javax.sql.DataSource;
import org.babyfish.jimmer.sql.runtime.ExecutionException;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface ConnectionManager {
    public static final ConnectionManager EXTERNAL_ONLY = new ConnectionManager(){

        @Override
        public <R> R execute(@Nullable Connection con, Function<Connection, R> block) {
            Objects.requireNonNull(con, "External connection cannot be null");
            return block.apply(con);
        }
    };

    public static ConnectionManager singleConnectionManager(final Connection connection) {
        return new ConnectionManager(){

            @Override
            public <R> R execute(@Nullable Connection con, Function<Connection, R> block) {
                return block.apply(con == null ? connection : con);
            }
        };
    }

    public static ConnectionManager simpleConnectionManager(final DataSource dataSource) {
        return new ConnectionManager(){

            @Override
            public <R> R execute(@Nullable Connection con, Function<Connection, R> block) {
                try {
                    return block.apply(con);
                }
                catch (Error | RuntimeException ex) {
                    throw ex;
                }
                catch (Throwable ex) {
                    throw new ExecutionException(ex.getMessage(), ex);
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public <R> R execute(Function<Connection, R> block) {
                try (Connection con = dataSource.getConnection();){
                    R r = block.apply(con);
                    return r;
                }
                catch (Error | RuntimeException ex) {
                    throw ex;
                }
                catch (Throwable ex) {
                    throw new ExecutionException(ex.getMessage(), ex);
                }
            }
        };
    }

    public <R> R execute(@Nullable Connection var1, Function<Connection, R> var2);

    default public <R> R execute(Function<Connection, R> block) {
        return this.execute(null, block);
    }
}

