/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import java.sql.PreparedStatement;
import java.util.Objects;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.sql.runtime.ExecutionException;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.JdbcTypes;
import org.babyfish.jimmer.sql.runtime.ParameterIndex;
import org.babyfish.jimmer.sql.runtime.ScalarProvider;

public interface DbLiteral {
    public Class<?> getType();

    default public void render(StringBuilder builder, JSqlClientImplementor sqlClient) {
        builder.append('?');
    }

    public void renderValue(StringBuilder var1);

    public void renderToComment(StringBuilder var1);

    public void setParameter(PreparedStatement var1, ParameterIndex var2, JSqlClientImplementor var3) throws Exception;

    public static Object unwrap(Object value) {
        if (value instanceof DbNull) {
            return null;
        }
        if (value instanceof DbValue) {
            return ((DbValue)value).value;
        }
        return value;
    }

    public static class DbNull
    implements DbLiteral {
        private final Class<?> type;

        public DbNull(Class<?> type) {
            this.type = type;
        }

        @Override
        public Class<?> getType() {
            return this.type;
        }

        @Override
        public void renderValue(StringBuilder builder) {
            builder.append("null");
        }

        @Override
        public void renderToComment(StringBuilder builder) {
            builder.append("<null: ").append(this.type.getSimpleName()).append('>');
        }

        @Override
        public void setParameter(PreparedStatement stmt, ParameterIndex index, JSqlClientImplementor sqlClient) throws Exception {
            stmt.setNull(index.get(), JdbcTypes.toJdbcType(this.type, sqlClient.getDialect()));
        }

        public int hashCode() {
            return Objects.hash(this.type);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DbNull dbNull = (DbNull)o;
            return this.type.equals(dbNull.type);
        }

        public String toString() {
            return "DbNull{type=" + this.type.getName() + '}';
        }
    }

    public static class DbValue
    implements DbLiteral {
        private final ImmutableProp prop;
        private final Object value;
        private final boolean converted;

        public DbValue(ImmutableProp prop, Object value, boolean converted) {
            if (value instanceof DbLiteral) {
                throw new IllegalArgumentException("value cannot be DbLiteral");
            }
            this.prop = prop;
            this.value = value;
            this.converted = converted;
        }

        @Override
        public Class<?> getType() {
            return this.value != null ? this.value.getClass() : this.prop.getReturnClass();
        }

        @Override
        public void render(StringBuilder builder, JSqlClientImplementor sqlClient) {
            ScalarProvider scalarProvider;
            builder.append('?');
            String suffix = sqlClient.getDialect().getJsonLiteralSuffix();
            if (this.value != null && suffix != null && (scalarProvider = sqlClient.getScalarProvider(this.prop)) != null && scalarProvider.isJsonScalar()) {
                builder.append(' ').append(suffix);
            }
        }

        @Override
        public void renderValue(StringBuilder builder) {
            if (this.value instanceof Number) {
                builder.append("null");
            } else {
                builder.append('\'').append(this.value.toString().replace("'", "''")).append('\'');
            }
        }

        @Override
        public void renderToComment(StringBuilder builder) {
            builder.append(this.value.toString());
        }

        @Override
        public void setParameter(PreparedStatement stmt, ParameterIndex index, JSqlClientImplementor sqlClient) throws Exception {
            Object value = this.value;
            ScalarProvider scalarProvider = null;
            if (value != null && !this.converted && (scalarProvider = sqlClient.getScalarProvider(this.prop)) != null) {
                try {
                    value = scalarProvider.toSql(value);
                }
                catch (Exception ex) {
                    throw new ExecutionException("The value \"" + value + "\" cannot be converted by the scalar provider \"" + scalarProvider + "\"");
                }
            }
            if (value == null) {
                stmt.setNull(index.get(), JdbcTypes.toJdbcType(scalarProvider != null ? scalarProvider.getSqlType() : this.prop.getReturnClass(), sqlClient.getDialect()));
            } else {
                stmt.setObject(index.get(), value, JdbcTypes.toJdbcType(value.getClass(), sqlClient.getDialect()));
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DbValue dbValue = (DbValue)o;
            if (this.converted != dbValue.converted) {
                return false;
            }
            if (!this.prop.equals((Object)dbValue.prop)) {
                return false;
            }
            return this.value.equals(dbValue.value);
        }

        public int hashCode() {
            int result = this.prop.hashCode();
            result = 31 * result + this.value.hashCode();
            result = 31 * result + (this.converted ? 1 : 0);
            return result;
        }

        public String toString() {
            return "DbValue{prop=" + this.prop + ", value=" + this.value + ", converted=" + this.converted + '}';
        }
    }
}

