/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.babyfish.jimmer.DraftConsumerUncheckedException;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.sql.runtime.Reader;

class ObjectReader
implements Reader<Object> {
    private static final Reader<?>[] EMPTY_READERS = new Reader[0];
    private final ImmutableType type;
    private final Reader<?> idReader;
    private final PropId[] nonIdPropIds;
    private final Reader<?>[] nonIdReaders;

    ObjectReader(ImmutableType type, Reader<?> idReader, Map<ImmutableProp, Reader<?>> nonIdReaders) {
        this.type = type;
        this.idReader = idReader;
        this.nonIdPropIds = (PropId[])nonIdReaders.keySet().stream().map(ImmutableProp::getId).toArray(PropId[]::new);
        this.nonIdReaders = nonIdReaders.values().toArray(EMPTY_READERS);
    }

    @Override
    public Object read(ResultSet rs, Reader.Context ctx) throws SQLException {
        Object id = this.idReader.read(rs, ctx);
        if (id == null) {
            ctx.addCol(this.nonIdReaders.length);
            return null;
        }
        DraftSpi spi = (DraftSpi)this.type.getDraftFactory().apply(ctx.draftContext(), null);
        spi.__set(this.type.getIdProp().getId(), id);
        try {
            int size = this.nonIdReaders.length;
            for (int i = 0; i < size; ++i) {
                Object value = this.nonIdReaders[i].read(rs, ctx);
                spi.__set(this.nonIdPropIds[i], value);
            }
        }
        catch (Throwable ex) {
            throw DraftConsumerUncheckedException.rethrow((Throwable)ex);
        }
        return ctx.resolve(spi);
    }
}

