/*
 * Decompiled with CFR 0.152.
 */
package org.bahmni.webclients;

import java.net.URI;
import java.util.List;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bahmni.webclients.Authenticator;
import org.bahmni.webclients.ClientCookies;
import org.bahmni.webclients.ConnectionDetails;
import org.bahmni.webclients.HttpHeaders;
import org.bahmni.webclients.HttpRequestDetails;
import org.bahmni.webclients.WebClientsException;

public class AnonymousAuthenticator
implements Authenticator {
    private static Logger logger = LogManager.getLogger(AnonymousAuthenticator.class);
    private final String SESSION_ID_KEY = "JSESSIONID";
    private final ConnectionDetails authenticationDetails;
    private HttpRequestDetails previousSuccessfulRequest;

    public AnonymousAuthenticator(ConnectionDetails authenticationDetails) {
        this.authenticationDetails = authenticationDetails;
    }

    @Override
    public HttpRequestDetails getRequestDetails(URI uri) {
        if (this.previousSuccessfulRequest == null || this.previousSuccessfulRequest.getClientCookies().size() == 0) {
            return this.refreshRequestDetails(uri);
        }
        return this.previousSuccessfulRequest.createNewWith(uri);
    }

    @Override
    public HttpRequestDetails refreshRequestDetails(URI uri) {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            BasicCookieStore cookieStore = new BasicCookieStore();
            BasicHttpContext httpContext = new BasicHttpContext();
            httpContext.setAttribute("http.cookie-store", (Object)cookieStore);
            httpClient.getParams().setParameter("http.socket.timeout", (Object)this.authenticationDetails.getReadTimeout());
            httpClient.getParams().setParameter("http.connection.timeout", (Object)this.authenticationDetails.getConnectionTimeout());
            HttpGet httpGet = new HttpGet(uri);
            logger.info(String.format("Executing request: %s", httpGet.getRequestLine()));
            ClientCookies clientCookies = new ClientCookies();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet, (HttpContext)httpContext);
            List cookies = cookieStore.getCookies();
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equalsIgnoreCase("JSESSIONID")) continue;
                clientCookies.put("JSESSIONID", cookie.getValue());
            }
            this.previousSuccessfulRequest = new HttpRequestDetails(uri, clientCookies, new HttpHeaders());
            HttpRequestDetails httpRequestDetails = this.previousSuccessfulRequest;
            return httpRequestDetails;
        }
        catch (Exception e) {
            throw new WebClientsException(e);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }
}

