/*
 * Decompiled with CFR 0.152.
 */
package org.bahmni.webclients;

import java.io.IOException;
import java.net.URI;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.util.EntityUtils;
import org.bahmni.webclients.Authenticator;
import org.bahmni.webclients.ClientCookies;
import org.bahmni.webclients.ConnectionDetails;
import org.bahmni.webclients.HttpClientInternal;
import org.bahmni.webclients.HttpHeaders;
import org.bahmni.webclients.NullAuthenticator;
import org.bahmni.webclients.ObjectMapperRepository;
import org.bahmni.webclients.WebClientsException;

public class HttpClient {
    private Authenticator authenticator;
    private HttpClientInternal httpClientInternal;

    public HttpClient(ConnectionDetails connectionDetails) {
        this(new HttpClientInternal(connectionDetails.getConnectionTimeout(), connectionDetails.getReadTimeout()));
    }

    public HttpClient(ConnectionDetails connectionDetails, Authenticator authenticator) {
        this(new HttpClientInternal(connectionDetails.getConnectionTimeout(), connectionDetails.getReadTimeout(), connectionDetails.getConnectionManager()), authenticator);
    }

    public HttpClient(HttpClientInternal httpClientInternal) {
        this(httpClientInternal, (Authenticator)new NullAuthenticator());
    }

    public HttpClient(HttpClientInternal httpClientInternal, Authenticator authenticator) {
        this.httpClientInternal = httpClientInternal;
        this.authenticator = authenticator;
    }

    public ClientCookies getCookies(URI uri) {
        return this.authenticator.getRequestDetails(uri).getClientCookies();
    }

    public String get(URI uri) {
        return this.get(uri, new HttpHeaders());
    }

    private String get(URI uri, HttpHeaders httpHeaders) {
        try {
            HttpResponse httpResponse = this.httpClientInternal.get(this.authenticator.getRequestDetails(uri), httpHeaders);
            if (httpResponse.getStatusLine().getStatusCode() == 401 || httpResponse.getStatusLine().getStatusCode() == 403) {
                this.httpClientInternal.closeConnection();
                this.httpClientInternal = this.httpClientInternal.createNew();
                httpResponse = this.httpClientInternal.get(this.authenticator.refreshRequestDetails(uri), httpHeaders);
            }
            this.checkSanityOfResponse(httpResponse);
            String string = this.asString(httpResponse);
            return string;
        }
        catch (IOException e) {
            throw new WebClientsException(e);
        }
        finally {
            this.httpClientInternal.closeConnection();
        }
    }

    public <T> T get(String url, Class<T> returnType) throws IOException {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.put("Accept", "application/json");
        String response = this.get(URI.create(url), httpHeaders);
        return (T)ObjectMapperRepository.objectMapper.readValue(response, returnType);
    }

    private void checkSanityOfResponse(HttpResponse httpResponse) {
        StatusLine statusLine = httpResponse.getStatusLine();
        int statusCode = statusLine.getStatusCode();
        if (statusCode < 200 || statusCode >= 300) {
            throw new WebClientsException("Bad response code of " + statusCode);
        }
        HttpEntity entity = httpResponse.getEntity();
        if (entity == null) {
            throw new WebClientsException("Cannot read response");
        }
    }

    private String asString(HttpResponse httpResponse) throws IOException {
        return EntityUtils.toString((HttpEntity)httpResponse.getEntity());
    }
}

