/*
 * Decompiled with CFR 0.152.
 */
package org.bahmni.webclients;

import java.io.IOException;
import org.apache.http.HttpMessage;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.bahmni.webclients.HttpHeaders;
import org.bahmni.webclients.HttpRequestDetails;
import org.bahmni.webclients.WebClientsException;

public class HttpClientInternal {
    private int connectTimeout;
    private int readTimeout;
    private CloseableHttpClient closeableHttpClient;
    private PoolingHttpClientConnectionManager connectionManager;

    HttpClientInternal(int connectionTimeout, int readTimeout) {
        this.connectTimeout = connectionTimeout;
        this.readTimeout = readTimeout;
    }

    HttpClientInternal(int connectionTimeout, int readTimeout, PoolingHttpClientConnectionManager connectionManager) {
        this.connectTimeout = connectionTimeout;
        this.readTimeout = readTimeout;
        this.connectionManager = connectionManager;
    }

    public HttpResponse get(HttpRequestDetails requestDetails) {
        return this.get(requestDetails, new HttpHeaders());
    }

    public HttpResponse get(HttpRequestDetails requestDetails, HttpHeaders httpHeaders) {
        HttpGet httpGet = new HttpGet(requestDetails.getUri());
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.readTimeout).setSocketTimeout(this.connectTimeout).build();
        if (this.connectionManager == null) {
            this.connectionManager = new PoolingHttpClientConnectionManager();
        }
        this.closeableHttpClient = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).setConnectionManager((HttpClientConnectionManager)this.connectionManager).build();
        requestDetails.addDetailsTo((HttpMessage)httpGet);
        httpHeaders.addTo((HttpMessage)httpGet);
        try {
            return this.closeableHttpClient.execute((HttpUriRequest)httpGet);
        }
        catch (IOException e) {
            throw new WebClientsException("Error executing request", e);
        }
    }

    void closeConnection() {
        if (this.closeableHttpClient != null && this.connectionManager == null) {
            try {
                this.closeableHttpClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public HttpClientInternal createNew() {
        return new HttpClientInternal(this.connectTimeout, this.readTimeout);
    }
}

