/*
 * Decompiled with CFR 0.152.
 */
package org.bahmni.webclients;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bahmni.webclients.Authenticator;
import org.bahmni.webclients.ClientCookies;
import org.bahmni.webclients.ConnectionDetails;
import org.bahmni.webclients.HttpHeaders;
import org.bahmni.webclients.HttpRequestDetails;
import org.bahmni.webclients.WebClientsException;

public class OpenElisAuthenticator
implements Authenticator {
    private static Logger logger = LogManager.getLogger(OpenElisAuthenticator.class);
    private final ConnectionDetails authenticationDetails;
    private HttpRequestDetails previousSuccessfulRequest;
    CloseableHttpClient httpClient;

    public OpenElisAuthenticator(ConnectionDetails authenticationDetails) {
        this.authenticationDetails = authenticationDetails;
    }

    @Override
    public HttpRequestDetails getRequestDetails(URI uri) {
        if (this.previousSuccessfulRequest == null || this.previousSuccessfulRequest.getClientCookies().size() == 0) {
            return this.refreshRequestDetails(uri);
        }
        return this.previousSuccessfulRequest.createNewWith(uri);
    }

    @Override
    public HttpRequestDetails refreshRequestDetails(URI uri) {
        try {
            BasicCookieStore cookieStore = new BasicCookieStore();
            BasicHttpContext httpContext = new BasicHttpContext();
            httpContext.setAttribute("http.cookie-store", (Object)cookieStore);
            HttpPost httpPost = new HttpPost(uri);
            logger.info(String.format("Executing request: %s", httpPost.getRequestLine()));
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.authenticationDetails.getConnectionTimeout()).setSocketTimeout(this.authenticationDetails.getReadTimeout()).build();
            this.httpClient = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("loginName", this.authenticationDetails.getUserId()));
            params.add(new BasicNameValuePair("password", this.authenticationDetails.getPassword()));
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost, (HttpContext)httpContext);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new WebClientsException("Authentication with OpenELIS failed");
            }
            ClientCookies clientCookies = new ClientCookies();
            List cookies = cookieStore.getCookies();
            for (Cookie cookie : cookies) {
                String SESSION_ID_KEY = "JSESSIONID";
                if (!cookie.getName().equalsIgnoreCase(SESSION_ID_KEY)) continue;
                clientCookies.put(SESSION_ID_KEY, cookie.getValue());
            }
            this.previousSuccessfulRequest = new HttpRequestDetails(uri, clientCookies, new HttpHeaders());
            HttpRequestDetails httpRequestDetails = this.previousSuccessfulRequest;
            return httpRequestDetails;
        }
        catch (Exception e) {
            throw new WebClientsException(e);
        }
        finally {
            try {
                this.httpClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

